/*
Simple four channel signal plot.
    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"

float m2_drawingstate = 0;	//Position in screen cords
float m2_scale = 0.001;		//Scale for dawing
float m2_drawingstate_offset = 0; //Move graph to left or right side
float m2_overview = 1; 		//Factor of what is more samplet than on screen,
                       		//within this left and right shift is possible

int m2_samples_since_trigger;	//Since last trigger occurence...

int m2_oldchannel;		//Which channel was the previous one

int m2_triggermode = 0;		//0: Rising/falling 1: Rising 2: Falling
unsigned int m2_triggermask;	//Which pins have an active trigger
int m2_triggerlevel = 64;
int m2_oldval[4];		//Needed for trigger

int m2_samples_on_screen(void) {
  return (int)(1.0/(m2_scale));
}

void m2_clearscreen(void) {
glutSetWindow(windowid_main);
glClear(GL_COLOR_BUFFER_BIT);
m2_printinfo();
}

void m2_getandprepare(int foo) {	//Get data from serial port and compress
int newchannel;
unsigned int newval;
int need_update = 0;
if (op_mode != 2) {			//Otherwise the funcion will use data
  return;				//from an other mode after swichting
}
while (fifo_data[fifo_rp] >= 0) {	//Loop to draw values
  newchannel = m2_oldchannel;
  newval = fifo_data[fifo_rp];		//The value
  //printf("%i\n", newval);
  fifo_rp_next();			//Update read pointer
  newchannel++;
  if (newval & 0x80) {			//This indicates channel 1
    if (newchannel < 4) {
      printf("m2_getandprepare: Warning: Wrong data. Missed data from previous channels. Got value: %i\n\r", newval);
    }
    newchannel = 0;
    m2_samples_since_trigger++;
    samples_c++;			//Count for stats
  }
  if (newchannel > 3) {
    printf("m2_getandprepare: Error: Wrong data. Missing data from channel 1. Got value: %i\n\r", newval);
    break;
  }
  newval &= 0x7f; 			//Remove Ch1 indication
  m2_drawgraph(newval, newchannel);	//Draw value
  need_update = 1;
  //Trigger set back
  if ((m2_triggermask & (1<<newchannel)) && 	//If channel has active trigger
      ((m2_samples_since_trigger >= m2_samples_on_screen()*m2_overview))) {
    if (((m2_triggermode == 1) || (m2_triggermode == 0)) &&
        (newval > m2_triggerlevel) &&
        (m2_oldval[newchannel] <= m2_triggerlevel)) {	//Rising edge
      m2_drawingstate = 0.0;
      draw_white_rectangle(-1.0,0.1,m2_scale*2.0-0.95,0.87); //Clear old drawing
      draw_white_rectangle(-1.0,-0.76,m2_scale*2.0-0.95,-0.1);//Clear old drawing
      m2_samples_since_trigger = 0;
      triggerrate_c++;			//Count for stats
    }
    if (((m2_triggermode == 2) || (m2_triggermode == 0)) &&
        (newval < m2_triggerlevel) &&
        (m2_oldval[newchannel] >= m2_triggerlevel)) {	//Falling edge
      m2_drawingstate = 0.0;
      draw_white_rectangle(-1.0,0.1,m2_scale*2.0-0.95,0.87); //Clear old drawing
      draw_white_rectangle(-1.0,-0.76,m2_scale*2.0-0.95,-0.1); //Clear old drawing
      m2_samples_since_trigger = 0;
      triggerrate_c++;			//Count for stats
    }
  } //End: Trigger active
  m2_oldval[newchannel] = newval;
  m2_oldchannel = newchannel;
} //End: Data in FIFO
if (op_mode == 2) {			//Only recall if still in this mode
  glutTimerFunc(15,m2_getandprepare, 0);	//Recall this function after 15ms
}
if (need_update) {
  glutPostRedisplay();
  glutPostOverlayRedisplay();
  glFlush();
}
}

void m2_drawgraph(int val, int channel) {
/*We get the values in val.
  The current drawing position is m2_drawingstate and m2_drawingstate_offset
  is an offset for shiftig eveything left
  m2_scale ... scales the drawing horizontally
  in the case m2_drawingstate reaches m2_overview and m2_triggermask is 0 we
  start from the beginning with m2_overview = 0
*/

float peg; //Pegel, needed for the lines
if (m2_drawingstate > m2_overview) { //Limmit line starting position
  m2_drawingstate = m2_overview;
}
float l_len = m2_scale; 	//Line length
if ((l_len + m2_drawingstate) > m2_overview) { //Limmit line length
  l_len = m2_overview-m2_drawingstate;
}
float l_start = m2_drawingstate-m2_drawingstate_offset; //Point to start line
float l_end = l_start+l_len;	//End of line
if (channel == 3) {		//Only every fourth time update!
  m2_drawingstate += l_len;	//New state for next time
}
//The screen goes from -1 to 1 and not 0..1 so we need to calc (val*2) lengths
// and (val*2)-1 absolute cordinates
//float s_len = l_len*2.0;	//Screen line length
float s_start = l_start*2.0-1.0;
float s_end = l_end*2.0-1.0;
//Reset m2_drawingstate if needed (only after all four lines have been drawn)
if ((m2_drawingstate >= m2_overview) && (m2_triggermask == 0) && (channel == 3)) {
  m2_drawingstate = 0.0;
}
//Remove old drawing
if (channel == 0) {
  draw_white_rectangle(s_start,0.1,s_end+0.05,0.87);	//Clear old drawing
  draw_white_rectangle(s_start,-0.76,s_end+0.05,-0.1);	//Clear old drawing
}
//Draw the value
float height = 0.0;
glPushMatrix();
if (channel == 0) {
  height = 0.65;
  glColor3f(1.0,0.3,0.3);
}
if (channel == 1) {
  height = 0.32;
  glColor3f(0.2,1.0,0.2);
}
if (channel == 2) {
  height = -0.265;
  glColor3f(0.1,0.1,1.0);
}
if (channel == 3) {
  height = -0.595;
  glColor3f(0.8,0.5,0.0);
}
glBegin(GL_LINES);
peg = (((float)(val))-64.0)*0.00234; //+- 0.15 on screen
glVertex2f(s_start, height+peg);
glVertex2f(s_end, height+peg);
glEnd();
glPopMatrix();
}

void m2_printinfo(void) {
int nun;
float samples_per_pix;
char label[200], labelb[200];
glutSetWindow(windowid_main);
//Write scale
glColor3f (0.0, 0.0, 0.0);
glRasterPos2f (-0.95, 0.9);
samples_per_pix = 1/(m2_scale*windowwidth);
sprintf(label, "Samples per pixel: %f", samples_per_pix);
draw_white_rectangle(-1.0,1.0,-0.4,0.86);	//Clear old text
drawstring(label);
//Write trigger
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(-0.4, 0.9);
if (m2_triggermask) {			//If trigger
  strcpy(label,"");
  strcpy(labelb,"");
  for (nun = 0; nun < 4; nun++) {	//Make list where triggers are active
    if (m2_triggermask & (0x01<<nun)) {
      sprintf(label, "%s %i",labelb,(nun+1));
    }
    sprintf(labelb,"%s", label);
  }					//List now in labelb
  if (m2_triggermode == 0) {
    sprintf(label,"Rising/falling trigger on inputs%s active",labelb);
  }
  if (m2_triggermode == 1) {
    sprintf(label,"Rising trigger on inputs%s active",labelb);
  }
  if (m2_triggermode == 2) {
    sprintf(label,"Falling trigger on inputs%s active",labelb);
  }
} else {
  sprintf(label, "Trigger is off");
}
draw_white_rectangle(-0.4,1.0,0.25,0.86);	//Clear old text
drawstring(label);
//Write View
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(0.25, 0.9);
sprintf(label,"%i %s of screen shown, start offset: %i %s",
        (int)((1.0/m2_overview)*100.0),"%",(int)(m2_drawingstate_offset*100.0), "%");
draw_white_rectangle(0.25,1.0,1.0,0.86);	//Clear old text
drawstring(label);
//Write stats
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(-0.95, -0.9);
sprintf(label, "Data rate: %i byte/s Sample rate: %i 1/s Trigger rate: %i 1/s",
        datarate_l, samples_l, triggerrate_l);
draw_white_rectangle(-1.0,-1.0,0.20,-0.755);	//Clear old text
drawstring(label);
//Trigger level
draw_white_rectangle(0.2,-1.0,0.6,-0.755);	//Clear old text
if (m2_triggermask) {
  glColor3f (0.0, 0.0, 0.0);
  glRasterPos2f(0.2, -0.9);
  sprintf(label, "Trigger level: %i",m2_triggerlevel);
  drawstring(label);
}
//FIFO load
if (fifo_max_l >= 95) {
  glColor3f (1.0, 0.0, 0.0);
} else {
  glColor3f (0.0, 0.0, 0.0);
}
glRasterPos2f(0.6, -0.9);
sprintf(label, "max FIFO usage: %i %s",fifo_max_l,"%");
draw_white_rectangle(0.6,-1.0,1.0,-0.755);	//Clear old text
drawstring(label);
//Write stats
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(-0.2, -0.05);
sprintf(label, "Screen shows %f ms",
        samples_per_pix*windowwidth*1000/gsamples_l);
draw_white_rectangle(-1.0,0.11,1.0,-0.11);	//Clear old text
drawstring(label);
glutPostRedisplay();
}
