/*
This file contains some simple functions which I did not find in the libc

    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"
#include <time.h>
#include <sys/time.h>

int hexextract(char* s, int length) {
//Converts a hexadecimal number from a string to an int.
//the length is the number of digits
int nun, number = 0, digit;

for (nun = 0; nun < length; nun++) {
  digit = (int)((*(s+nun))-48);
  if (digit > 9) {
    digit -= 7;
  }
  number *= 16;
  number += digit;
}
return number;
}

void inttohex(char* s, int value, int digits) {
/*Converts a int to a hexadecimal in a string with leading zeros. Well for
  converting back with hexextract(). In tis case digits and length should be
  the same. */
int nun, digi;
for (nun = 0; nun < digits; nun++) {
  digi = (value % 16);
  value /= 16;
  if (digi > 9) {
    digi += 7;
  }
  digi += 48;
  *(s+digits-nun-1) = digi;
}
}

unsigned long long get_time10k(void) {
struct timeval data1;
long long time10k;
//10000=10k ist eine Sekunde
gettimeofday (&data1, NULL);
time10k = data1.tv_sec*10000+data1.tv_usec/100;
return time10k;
}

float fmaxf(float a, float b) {
/*I wrote my own fmaxf because i did not found out how to use libc funcion
  without getting a
  "warning: incompatible implicit declaration of built-in function 'fmaxf'"
*/
if (a < b) {
  return b;
}
return a;
}

float fminf(float a, float b) {
//The libc function generates the same type of warning as fmaxf above
if (a < b) {
  return a;
}
return b;
}
