/*
Simple four channel signal plot.
    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"

int data[maxchannel][sampleaverage];	//Data
int datap[maxchannel];			//Pointer for data
float olddrawing[maxchannel];

void m3_clearscreen(void) {
glutSetWindow(windowid_main);
glClear(GL_COLOR_BUFFER_BIT);
m3_printinfo();
}

void m3_getandprepare(int foo) {	//Get data from serial port and compress
unsigned int valh,vall, channel, val;
int temp;
if (op_mode != 3) {			//Otherwise the funcion will use data
  return;				//from an other mode after swichting
}
while ((fifo_data[fifo_rp] >= 0) &&
       ((fifo_data[(fifo_rp+1)%fifo_size]) >= 0)) {	//Loop to compress and draw values
  valh = fifo_data[fifo_rp];		//The value upper part
  fifo_rp_next();			//Update read pointer
  if ((valh & 0x80) == 0) {
    printf("m3_getandprepare: Error: Out of sync, ignoring data\n\r");
    break;
  }
  temp = fifo_data[fifo_rp];		//the value lower part
  if (temp < 0) {
    printf("m3_getandprepare: Error: Data not complete\n\r");
    break;
  }
  vall = temp;
  if (vall & 0x80) {
    printf("m3_getandprepare: Error: Out of sync, channel: %i high bits: %i\n\r",
           (valh >> 5) & 0x03,  (valh & 0x1f));
    break;
  }
  fifo_rp_next();
  channel = (valh >> 5) & 0x03;		//Which channel were the data from
  if (channel >= maxchannel) {
    printf("m3_getandprepare: Error: Too high channel, possible a bug\n\r");
    break;
  }
  val = vall + ((valh & 0x1f)<<7);
  data[channel][datap[channel]] = val;	//Save in buffer
  datap[channel]++;			//Inc adress
  datap[channel] %= sampleaverage;
  if ((datap[channel] % 10) == 0) {
    m3_drawgraph(channel);		//Draw value
  }
} //End: Data in FIFO
if (op_mode == 3) {			//Only recall if still in this mode
  glutTimerFunc(15,m3_getandprepare, 0);	//Recall this function after 15ms
}
}

int m3_calcaverage(int channel) {
int nun;
long sum = 0;
for (nun = 0; nun < sampleaverage; nun++) {
  sum += data[channel][nun];
}
return (sum/sampleaverage);
}

int m3_calcmax(int channel) {
int nun;
int max = 0;
for (nun = 0; nun < sampleaverage; nun++) {
  if (data[channel][nun] > max) {
    max = data[channel][nun];
  }
}
return max;
}

int m3_calcmin(int channel) {
int nun;
int min = data[channel][0];
for (nun = 1; nun < sampleaverage; nun++) {
  if (data[channel][nun] < min) {
    min = data[channel][nun];
  }
}
return min;
}

void m3_drawgraph(int channel) {
char label[200];
float posx, alpha, px,py;
int min, max, medium;
min = m3_calcmin(channel);
max = m3_calcmax(channel);
medium = m3_calcaverage(channel);
posx = -0.95 + ((float)channel)*0.5;
//Convert into mV
min = min*5000/4096;
max = max*5000/4096;
medium = medium*5000/4096;
//Draw grey box
glutSetWindow(windowid_main);
glPushMatrix();
glBegin(GL_QUADS);
glColor3f(0.5, 0.5, 0.5);		//grey color
glVertex2f(posx, 0.0);
glVertex2f(posx+0.4, 0.0);
glVertex2f(posx+0.4, -0.4);
glVertex2f(posx, -0.4);
glEnd();
glPopMatrix();
//Draw medium value
sprintf(label,"%imV",medium);
glColor3f(1.0, 1.0, 1.0);
glRasterPos2f(posx+0.15, -0.1);
drawstring(label);
//Draw max value
sprintf(label,"max: %imV",max);
glColor3f(1.0, 1.0, 1.0);
glRasterPos2f(posx+0.15, -0.2);
drawstring_small(label);
//Draw min value
sprintf(label,"min: %imV",min);
glColor3f(1.0, 1.0, 1.0);
glRasterPos2f(posx+0.15, -0.3);
drawstring_small(label);
//Remove old pointer
alpha = olddrawing[channel];
px = cos(alpha)*(-0.2);
py = sin(alpha)*0.2;
glPushMatrix();
glColor3f(1.0,1.0,1.0);
glBegin(GL_LINES);
glVertex2f(posx+0.2, 0.01);
glVertex2f(posx+0.2+px, 0.01+py);
glEnd();
glPopMatrix();
//Draw new pointer
alpha = ((float)(medium))/5000.0*3.14159;
px = cos(alpha)*(-0.2);
py = sin(alpha)*0.2*(((float)windowwidth)/((float)windowheight));
glPushMatrix();
glColor3f(0.2,1.0,0.2);
glBegin(GL_LINES);
glVertex2f(posx+0.2, 0.01);
glVertex2f(posx+0.2+px, 0.01+py);
glEnd();
glPopMatrix();
//Update screen
glutPostRedisplay();
glutPostOverlayRedisplay();
glFlush();
}

void m3_printinfo(void) {
char label[200];
glutSetWindow(windowid_main);
//Write scale
draw_white_rectangle(-1.0,1.0,1.0,0.0);		//Clear screen above
draw_white_rectangle(-1.0,0.0,-0.95,-0.4);	//Clear screen far left
draw_white_rectangle(-0.55,0.0,-0.45,-0.4);	//Clear screen left
draw_white_rectangle(-0.05,0.0,0.05,-0.4);	//Clear screen middle
draw_white_rectangle(0.45,0.0,0.55,-0.4);	//Clear screen right
draw_white_rectangle(0.95,0.0,1.0,-0.4);	//Clear screen far right
m3_drawgraph(0);
m3_drawgraph(1);
m3_drawgraph(2);
m3_drawgraph(3);
draw_white_rectangle(-1.0,-0.4,1.0,-1.0);	//Clear screen below
//Write stats
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(-0.95, -0.9);
sprintf(label, "Data rate: %i byte/s", datarate_l);
drawstring(label);
//FIFO load
if (fifo_max_l >= 95) {
  glColor3f (1.0, 0.0, 0.0);
} else {
  glColor3f (0.0, 0.0, 0.0);
}
glRasterPos2f(0.6, -0.9);
sprintf(label, "max FIFO usage: %i %s",fifo_max_l,"%");
draw_white_rectangle(0.6,-1.0,1.0,-0.755);	//Clear old text
drawstring(label);
glutPostRedisplay();
}
