/*
Simple four channel signal plot. Version 2.1
    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef MAIN_H
  #define MAIN_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <GL/freeglut.h>
#include <pthread.h>
#include <termios.h>
#include <fcntl.h>
#include <math.h>
#include <unistd.h>

#define supported_dev_type 1
#define supported_sw 2

//Messages about time delays or not
#define no_update_stats_thread_difftime_messages 1

#include "simplers232.h"
#include "fifothread.h"
#include "screens.h"
#include "userin.h"
#include "devcom.h"
#include "mylib.h"
#include "signala.h"
#include "oszi.h"
#include "multi.h"
#include "dds.h"

int volatile op_mode;

//Some statistics
int volatile datarate_c;	//Current received bytes
int volatile datarate_l;	//Last received bytes
int volatile samples_c;		//Current received samples
int volatile samples_l;		//Last received samples
int volatile gsamples_l;	//Global last samples
int volatile triggerrate_c;	//Current trigger rate
int volatile triggerrate_l;	//Last trigger rate
int volatile fifo_max_c;	//Current maximum data got from FIFO
int volatile fifo_max_l;	//Last maximum data got from FIFO

pthread_t update_stats_thread_id;

int main(int argc, char **argv);
void main_part2(int foo);
void *update_stats_thread(void * arg);
void periodic_update(int foo);
void info(void);
void exit_app(void);

#endif
