/*
Simple four channel signal plot. Version 2.1
    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"


int volatile op_mode = 0; 	//0: off, 1: Digital Sample, 2 Analog Sample
				//3: Multimeter 4: Signalgenerator

//Some statistics
int volatile datarate_c = 0;	//Current received bytes
int volatile datarate_l = 0;	//Last received bytes
int volatile samples_c = 0;	//Current received samples
int volatile samples_l = 0;	//Last received samples
int volatile gsamples_l = 0;	//Global last samples
int volatile triggerrate_c = 0;	//Current trigger rate
int volatile triggerrate_l = 0;	//Last trigger rate
int volatile fifo_max_c = 0;	//Current maximum data got from FIFO
int volatile fifo_max_l = 0;	//Last maximum data got from FIFO
pthread_t update_stats_thread_id;

int main(int argc, char **argv) {
info();				//Console info
//GLUT Init
glutInit(&argc, argv);
glutInitDisplayMode(GLUT_RGBA);
glutInitWindowSize(windowwidth,windowheight);	//Size of main window
glutInitWindowPosition(10,100);		//Position of main window
windowid_main = glutCreateWindow("simple signal plot"); //Create main window
glClearColor(1.0,1.0,1.0,1.0);		//Color for clearing the screen
usleep(1000);
glClear(GL_COLOR_BUFFER_BIT);		//Clear screen now
glutReshapeFunc(window_size_update);	//Window size modyfied by user
glutVisibilityFunc(screen_text_update_foo);	//Window ist overlapped or minimized etc
glutSpecialFunc(input_key_cursor);	//React on cursor keys
glutKeyboardFunc(input_key_key);	//React on normal keys
glutMouseFunc(mousepress);		//React on mouse keypress
glutMotionFunc(mousemove);		//React on mouse move
//Create about window
windowid_about = glutCreateSubWindow(windowid_main,windowwidth/2-380 , 25, 760,
                 windowheight-50);	//Create about window
glutSetWindow(windowid_about);
glutDisplayFunc(printabout);
glutKeyboardFunc(input_key_key);	//React on normal keys
glutHideWindow();
//Create help window
windowid_help = glutCreateSubWindow(windowid_main, windowwidth/2-350, 40, 700,
                 windowheight-80);	//Create about window
glutSetWindow(windowid_help);
glutDisplayFunc(printhelp);
glutKeyboardFunc(input_key_key);	//React on normal keys
glutHideWindow();
//Creates logic window
m1_windowid_logic = glutCreateSubWindow(windowid_main, windowwidth/2-175,
                  windowheight/2-100, 350, 200);	//Create logic window
glutSetWindow(m1_windowid_logic);
glutDisplayFunc(m1_showlogic);
glutKeyboardFunc(input_key_key);
glutHideWindow();
//Create scan window
windowid_scan = glutCreateSubWindow(windowid_main, windowwidth/2-200,
                  windowheight/2-50, 400, 80);	//Create scan window
glutSetWindow(windowid_scan);
glutDisplayFunc(printscan);
glutShowWindow();
//Back to main window
glutSetWindow(windowid_main);
//Register proper port-close function
glutCloseFunc(exit_app); //If someone clicks on the 'X' of the window manager
//Register function to scan for the device and does the rest of the initialization
glutTimerFunc(200,main_part2, 0);
//Generate default line in mode 4
m4_predev_datafield(1);
//Go into GLUT loop
glutMainLoop();
return 0;
}

void main_part2(int foo) {
//This was previous in the main function but since for this part we need a GUI
//it is now called by a glutTimerFunc
//Serial Init
if (device_scan() < 0) {
   printf("main_part2: Error: No proper sampler device found, exiting\n\r");
   printscan_updatetext("No sampler circuit found, exiting");
   sleep(2);
   exit(1);			//Something went wrong opening the port
}
//Use 230400 baud for the fast data transfer or 9600 of you have problems
//and mode 3 and 5 are enough for you.
if (device_switch_baud(230400) < 0) { //if device has switched baudrate
   printf("main_part2: Error: Changing baudrate did not work, exiting\n\r");
   printscan_updatetext("Changing baudrate did not work, exiting");
   sleep(2);
   exit(1);			//Could not set baud rate
}
glutTimerFunc(1000,periodic_update, 0);	//Print stats
//Init fifo thread
fifo_clear();
if (pthread_create(&fifo_receive_thread_id, NULL, fifo_receive_thread,
   (void *)(0))) {
  printf("main_part2: Creating fifo_receive_thread failed\n");
}
//Init stats thread
if (pthread_create(&update_stats_thread_id, NULL, update_stats_thread,
   (void *)(0))) {
  printf("main_part2: Creating update_stats_thread failed\n");
}
device_voltage();
glutSetWindow(windowid_help);
glutShowWindow();
}

void *update_stats_thread(void * arg) {
printf("update_stats_thread: Info: Thread for stats updating started\n");
unsigned long long nowtime, nexttime;
unsigned long difftime;
float datacorrector;

nexttime = get_time10k();
for(;;) {
  nexttime += 10000;
  usleep(990000);
  while (get_time10k() < nexttime);
  nowtime = get_time10k();
  difftime = nowtime-nexttime;		//Should be 10000
  if ((difftime > 0) && (no_update_stats_thread_difftime_messages == 0)) {
    printf("update_stats_thread: Info: difftime %ld\n",difftime);
  }
  /* Theoretically I would need mutex locks around the reading and clearing of
     the variables for the stats but this would require mutex locks in the
     fifo_receive_thread() too. And because the fifo_receive_thread() is already
     shortly before (and sometimes over) loosing data from the RS232 port, I
     did not want that he fifo_receive_thread() even needs more time (and
     loosing data) just by waiting for this less important
     update_stats_thread(). */

  datacorrector = 1.0+((float)difftime)/10000.0;
  datarate_l = datarate_c;
  datarate_c = 0;
  datarate_l = (int)((float)(datarate_l)/datacorrector);
  samples_l = samples_c;
  samples_c = 0;
  samples_l = (int)((float)(samples_l)/datacorrector);
  if (samples_l > 0) {
    if (gsamples_l == 0) {
      gsamples_l = samples_l;
    } else {
      gsamples_l = (samples_l + gsamples_l*5)/6;
    }
  }
  triggerrate_l = triggerrate_c;
  triggerrate_c = 0;
  triggerrate_l = (int)((float)(triggerrate_l)/datacorrector);
  fifo_max_l = fifo_max_c *100/254;
  fifo_max_c = 0;
}
}

void periodic_update(int foo) {
//Updates what is drawn on the screen
int delayms = 300;
screen_text_update();
if (op_mode == 4) {			//No real periodic update neede here
  delayms = 3000;
}
glutTimerFunc(delayms,periodic_update, 0);	//Print stats
}

void info(void) {			//Print usage information at beginning
printf("info: Simple signal plot, Version 2.1, (c) 2006 by Malte Marwedel\n\r");
printf("info: press 'l' in window to see license\n\r");
printf("info: You do not need to give the program a port, it will search for you\n\r");
}

void exit_app(void) {
device_mainmode();
usleep(100000);
device_reactivate();
serial_clear();
send_dev_cmd("R");
serial_get();
if (rs232recbuf[1] == 'K') {
  printf("exit_app: Info: Device reseted\n\r");
}
serial_close();
exit(0);
}
