/*
Simple four channel signal plot.
    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"

//Receive FIFO
int volatile fifo_data[fifo_size];	//FIFO
int fifo_rp = 0;
int fifo_wp = 0;
pthread_t fifo_receive_thread_id;

//Indicates if the thread is using the FIFO and the serial port or not
//Note that the variable might be updated by the thred somewhat later, so you
//might get outdated states.
int volatile thread_active;

void fifo_clear(void) {
//You have make sure that the fifo thread has been aborted or op_mode is 0
//before calling this function
int nun;
int old_mode = op_mode;
op_mode = 0;
while (thread_active) {};		 //Wait until safe to write
for (nun = 0; nun < fifo_size; nun++) {
  fifo_data[nun] = -1;
}
fifo_rp = 0;
fifo_wp = 0;
op_mode = old_mode;			//Back to previous state
}

void fifo_rp_next(void) {
fifo_data[fifo_rp] = -1;		//Declare as empty
fifo_rp++;
if (fifo_rp == fifo_size) {
  fifo_rp = 0;
}
}

void *fifo_receive_thread(void * arg) {
int reccount,nun;
unsigned char volatile converter;
printf("receive_fifo_thread: Info: Thread for UART FIFO started\n");
for (;;) {
  if ((op_mode > 0) && (op_mode < 4)) {
    thread_active = 1;
    reccount = serial_get_fast();
    if (reccount > 0) {
      datarate_c += reccount;			//Count for stats
      if ( fifo_max_c < reccount) {		//Some more stats
        fifo_max_c = reccount;
      }
      for (nun = 0; nun < reccount; nun++) {	//Loop for received data
        if (fifo_data[fifo_wp] == -1) {		//FIFO Free
          converter = (unsigned char)rs232recbuf[nun];
          fifo_data[fifo_wp] = converter;
          fifo_wp++;
          if (fifo_wp == fifo_size) {
            fifo_wp = 0;
          }
        } else {				//Otherwise FIFO full
          printf("receive_fifo_thread: FIFO Overflow\n");
          usleep(100000);			//Give the app time to free FIFO
        }
      }						//End: loop
    }						//End: we got data
  } else {					//End: mode which uses FIFO
    thread_active = 0;
    usleep(10000);
  }
}						//End: endless loop
printf("receive_fifo_tread: Thread for UART FIFO stopped\n");	//Never happens
return(NULL);
}
