/*
Simple four channel signal plot.
    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef DDS_H
  #define DDS_H

#define only_six_bit_da 1

//Maximum output voltage @ Vcc = 5V
//Calibrate by setting the graph on maximum voltage and measure the output
//voltage with a multimeter. Then place your value here and compile again.

#define m4_maxout 4.91

#define m4_max_modes 5

//Needed for displaying the right frequency (no other use)
//#define F_CPU 11059200.0
#define F_CPU 14745600
#define avr_loop_ticks 10.0
#define avr_delay_ticks 4.0

int m4_delay;
int m4_currwave;

void m4_predev_datafield(int mode);
void m4_curveadjust(int x, int y);
void m4_clearscreen(void);
void m4_updatedata(void);
void m4_datafieldavr_clear(void);
void m4_uploaddata(void);
float m4_vmin(void);
float m4_vmax(void);
float m4_vaverage(void);
int m4_pstate(int position, int h);
int m4_freqanalyze(void);
void m4_printmodinfo(int pos);
void m4_drawbar(int pos);
void m4_printinfo(void);

#endif
