/*
Simple four channel signal plot.
    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"

int m4_datafield[256];
int m4_datafieldavr[256];//Will be simmilar to m4_datafield after m4_uploaddata();
int m4_delay = 2;

int m4_currwave;


void m4_predev_datafield(int mode) {
int nun;
if (mode == 0) { 	//Clear all
  for (nun = 0; nun < 256; nun++) {
    m4_datafield[nun] = 0;
  }
}
if (mode == 1) { 	//Rising line
  for (nun = 0; nun < 256; nun++) {
    m4_datafield[nun] = nun;
  }
}
if (mode == 2) { 	//Triangle
  for (nun = 0; nun < 256; nun++) {
    m4_datafield[nun] = abs(nun*2-255);
  }
}
if (mode == 3) { 	//Fast rectangle
  for (nun = 0; nun < 256; nun++) {
    m4_datafield[nun] = (nun%2)*255;
  }
}
if (mode == 4) { 	//Cosine
  for (nun = 0; nun < 256; nun++) {
    m4_datafield[nun] = 127+(int)(cos(3.141/128.0*((float)nun))*127.0);
  }
}
m4_currwave = mode;
}

void m4_curveadjust(int x, int y) {
float posx, posy;
int tpos, hpos;		//Table pos, height pos

posx = cursor_screenaxis_x(x);
posy = cursor_screenaxis_y(y);
if ((posx > -0.9) && (posx < 0.9) && (posy > -0.9) && (posy < 0.6)) {
  tpos = (int)(((posx+0.9)/1.8)*256.0);
  hpos = 255-(int)(((posy+0.8)/1.3)*256.0);
  if (hpos < 0) {
    hpos = 0;
  }
  if (hpos > 255) {
    hpos = 255;
  }
  if ((tpos >= 0) && (tpos < 256)) {
    m4_datafield[tpos] = hpos;
    m4_drawbar(tpos);
  }
  m4_printmodinfo(tpos);
}
}

void m4_clearscreen(void) {
glutSetWindow(windowid_main);
glClear(GL_COLOR_BUFFER_BIT);
m4_printinfo();
}

void m4_updatedata(void) {
//Goes back to main menu, selects mode M4 and calls upload data
device_mainmode();
m4_uploaddata();
}

void m4_datafieldavr_clear(void) {
int nun;
for (nun = 0; nun < 256; nun++) {
  m4_datafieldavr[nun] = 0;
}
}

void m4_uploaddata(void) {
char str[3] = "00\0";
int nun, val;
//Uploads the delay and the datafield
printscan_updatetext("Uploading data to AVR...");
serial_clear();
//Upload the delay
if ((m4_delay > 0) && (m4_delay < 65536)) {
  inttohex(str, m4_delay/256, 2);
  usleep(60000);		//Otherwise data get lost (I've tested it)
  serial_put(str);
  usleep(30000);			//The AVR is not that fast
  inttohex(str, m4_delay%256, 2);
  serial_put(str);
  usleep(20000);
  //Uploading data field
  serial_clear();
  for (nun = 0; nun < 256; nun++) {
    if ((m4_datafield[nun] < 0) || (m4_datafield[nun] > 255)) {
      printf("m4_uploaddata: Warning: Value in m4_datafield[%i] is out of range\n\r",nun);
    }
    val = m4_datafield[nun];
    if (only_six_bit_da) {	//With an ATMEGA8 you have only 6 and not 8 Bit
      val /= 4;
      m4_datafieldavr[nun] = val*4; //6 Bit adjusted
    } else
      m4_datafieldavr[nun] = val;
    inttohex(str,val,2);
    str[2] = '\0';
    serial_put(str);
    usleep(3000);		//Time for the UART
  } //End: Loop
  usleep(200000);
  serial_get();
  if (rs232recbuf[1] == 'K') {
    printscan_updatetext("Uploading data to AVR done");
    printf("m4_uploaddata: Info: New data uploaded\n\r");
  } else {
    printscan_updatetext("Uploading failed, please reset");
    printf("m4_uploaddata: Error: Uploading data has failed, please reset AVR and restart program\n\r");
  }
} else { 			//invalid m4_delay
  printscan_updatetext("Error: Uploading failed");
  printf("m4_uploaddata: Error: m4_delay is out of range\n\r");
}
}

float m4_vmin(void) {
int nun;
int mini = 256;
for (nun = 0; nun < 256; nun++) {
  if (m4_datafield[nun] < mini) {
    mini = m4_datafield[nun];
  }
}
return (((float)mini/255.0)*m4_maxout);
}

float m4_vmax(void) {
int nun;
int maxi = 0;
for (nun = 0; nun < 256; nun++) {
  if (m4_datafield[nun] > maxi) {
    maxi = m4_datafield[nun];
  }
}
return (((float)maxi/255.0)*m4_maxout);
}

float m4_vaverage(void) {
int nun;
int averag = 0;
for (nun = 0; nun < 256; nun++) {
  averag += m4_datafield[nun];
}
return (((float)averag/255.0/256.0)*m4_maxout);
}

int m4_pstate(int position, int h) {
if (m4_datafield[position] >= h) {
  return 1;
}
return 0;
}

int m4_freqanalyze(void) {
//Counts the toggles at the height of the average voltage level (except line 0)
int h,p,currfreq = 0,pstate;
int maxfreq = 0;

h = (int)(m4_vaverage()*255.0/m4_maxout);
if (h < 1) { 		//Line 0 is invalid for analyzing
  h = 1;
}
if (h > 255) {		//Should never happen
  printf("m4_freqanalyze: Warning: Index out of range, possible programming bug\n\r");
  h = 255;
}
pstate = m4_pstate(255,h);	//Init with last position
for (p = 0; p < 256; p++) {	//Scan position
  if (pstate != m4_pstate(p,h)) {
    currfreq++;
    pstate = 1-pstate;	//Since binary, just toggle
  }
}
if (currfreq > maxfreq) {
  maxfreq = currfreq;
}
return (maxfreq/2);
}

void m4_printmodinfo(int pos) {
//Prints the currend and previous voltage at the position of the mouse
char label[200];
float volt_o, volt_c;
volt_c = ((float)m4_datafield[pos]/255.0)*m4_maxout;
volt_o = ((float)m4_datafieldavr[pos]/255.0)*m4_maxout;
sprintf(label,"%.3f V (%.3f V)",volt_c,volt_o);
draw_white_rectangle(-0.5,1.0,0.5,0.91);	//Clear old text
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(-0.5, 0.91);
drawstring(label); //Draw the text
glutPostRedisplay();
glutPostOverlayRedisplay();
}

void m4_drawbar(int pos) {
/*Draws one of the 256 bars
  The value in the AVR is displayed blue, the value which will be uploaded is
  displayed green, if both overlap, the colors were mixed */

const float widthgraph = 0.004;
const float widthclear = 1.8/256.0;
const float heightclear = 1.3;
const float down = -0.5;
const float heightgraph = ((float)(m4_datafield[pos]))*heightclear/256.0;
const float heightgraphavr = ((float)(m4_datafieldavr[pos]))*heightclear/256.0;
const float leftclear = -0.9+widthclear*((float)(pos));
const float leftgraph = leftclear+(widthgraph-widthclear)/2.0;

glutSetWindow(windowid_main);
//Clear old bar
draw_white_rectangle(leftclear,down,leftclear+widthclear,down+heightclear);
//Draw bars
if (heightgraph >= heightgraphavr) { //Draw heightgraph first
  glPushMatrix();
  glBegin(GL_QUADS);
  glColor3f(0.3, 1.0, 0.0);		//Green color
  glVertex2f(leftgraph, down);
  glVertex2f(leftgraph, down+heightgraph);
  glVertex2f(leftgraph+widthgraph, down+heightgraph);
  glVertex2f(leftgraph+widthgraph, down);
  glEnd();
  glPopMatrix();
  //Now heightgraphavr
  glPushMatrix();
  glBegin(GL_QUADS);
  glColor3f(0.3, 1.0, 1.0);		//Blue+green color due overlay
  glVertex2f(leftgraph, down);
  glVertex2f(leftgraph, down+heightgraphavr);
  glVertex2f(leftgraph+widthgraph, down+heightgraphavr);
  glVertex2f(leftgraph+widthgraph, down);
  glEnd();
  glPopMatrix();
} else {				//Draw heightgraphavr first
  glPushMatrix();
  glBegin(GL_QUADS);
  glColor3f(0.3, 0.0, 1.0);		//Blue color
  glVertex2f(leftgraph, down);
  glVertex2f(leftgraph, down+heightgraphavr);
  glVertex2f(leftgraph+widthgraph, down+heightgraphavr);
  glVertex2f(leftgraph+widthgraph, down);
  glEnd();
  glPopMatrix();
  //Now heightgraphavr
  glPushMatrix();
  glBegin(GL_QUADS);
  glColor3f(0.3, 1.0, 1.0);		//Blue+green color due overlay
  glVertex2f(leftgraph, down);
  glVertex2f(leftgraph, down+heightgraph);
  glVertex2f(leftgraph+widthgraph, down+heightgraph);
  glVertex2f(leftgraph+widthgraph, down);
  glEnd();
  glPopMatrix();
}
}

void m4_printinfo(void) {
//Draws everything you see in the main window if mode 4 is selected
int nun;
char label[200];
float graph_f,graph_t,line_t,out_f;
glutSetWindow(windowid_main);
//Calc data
graph_f = F_CPU/((avr_loop_ticks+m4_delay*avr_delay_ticks)*256.0);
graph_t = (1.0/graph_f)*1000.0;
line_t = graph_t / 256.0;
out_f = graph_f*((float)m4_freqanalyze());
//clear top
draw_white_rectangle(-1.0,1.0,1.0,0.8);
//clear left
draw_white_rectangle(-1.0,1.0,-0.9,-0.5);
//clear right
draw_white_rectangle(1.0,1.0,0.9,-0.5);
//draw new graph
for (nun = 0; nun < 256; nun++) {
  m4_drawbar(nun);
}
//Rectangle around the graph
glPushMatrix();
glBegin(GL_LINE_LOOP);
glColor3f(0.0, 0.0, 0.0);			//Black color
glVertex2f(-0.905, 0.801);
glVertex2f(0.9,0.801);
glVertex2f(0.9,-0.501);
glVertex2f(-0.905,-0.501);
glEnd();
glPopMatrix();
//Draw analyze
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(-0.9, -0.68);
sprintf(label,"Voltage: min %.3fV max %.3fV average %.3fV                                Analyze of output frequency: %.4f Hz",m4_vmin(),m4_vmax(),m4_vaverage(),out_f);
draw_white_rectangle(-1.0,-0.5,1.0,-0.7);	//Clear old text
drawstring(label); //Draw the text
//Rectangle around the graph again
glPushMatrix();
glBegin(GL_LINE_LOOP);
glColor3f(0.0, 0.0, 0.0);			//Black color
glVertex2f(-0.905, 0.801);
glVertex2f(0.9,0.801);
glVertex2f(0.9,-0.501);
glVertex2f(-0.905,-0.501);
glEnd();
glPopMatrix();
//Draw status text
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(-0.9, -0.83);
sprintf(label,"Whole graph loops with %.4f Hz, equal to %.5f ms                  Each line is active for %f ms",graph_f,graph_t,line_t);
draw_white_rectangle(-1.0,-0.7,1.0,-0.9);	//Clear old text
drawstring(label); //Draw the text
//Draw hint
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(-0.6, -0.95);
sprintf(label,"Please note: Frequncy and waveform were only updated after pressing 's'");
draw_white_rectangle(-1.0,-0.9,1.0,-1.0);	//Clear old text
drawstring_verysmall(label); //Draw the text
glutPostRedisplay();
glutPostOverlayRedisplay();
}
