/*
RS232 I/O routines
    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <termios.h>
#include <fcntl.h>

#define port_default1 "/dev/ttyUSB0"
#define port_default2 "/dev/ttyS0"

char port_to_use[255];

//#define baud B115200
#define baud B230400

int fd_rs232;			//File descriptor for the port
unsigned char rs232recbuf[255];	//Recive buffer
struct termios options_port;	//Control the serial port behaviour


int serial_open(char *port_wish) {
//Read-write, nodelay and no control lines open
if (port_wish == NULL) {
  printf("serial_open: No ports specified, will try common ports\n");
  strcpy(port_to_use, port_default1);
  fd_rs232 = open(port_to_use, O_RDWR | O_NOCTTY | O_NDELAY);
  if (fd_rs232 < 0) {
    printf("serial_open: Unable to open %s; will try other port\n",port_to_use);
    strcpy(port_to_use, port_default2);
    fd_rs232 = open(port_to_use, O_RDWR | O_NOCTTY | O_NDELAY);
    if (fd_rs232 < 0) {
      printf("serial_open: Unable to open %s\n",port_to_use);
    }
  }
} else {		//There is a port as parameter
  if (strlen(port_wish) > 254) {
    printf("serial_open: Specified port parameter is too long, exiting  %s\n",port_to_use);
    exit(0);
  }
  strcpy(port_to_use, port_wish);
  fd_rs232 = open(port_to_use, O_RDWR | O_NOCTTY | O_NDELAY);
  if (fd_rs232 < 0) {
    printf("serial_open: Unable to open %s\n",port_to_use);
  }
}
if (fd_rs232 >= 0) {			//Port opened
  printf("serial_open: %s successfully opened\n",port_to_use);
  fcntl(fd_rs232, F_SETFL, O_NDELAY | O_NONBLOCK ); //No delay and non block device
  tcgetattr(fd_rs232, &options_port);	//load current settings into struct
  cfsetispeed(&options_port, baud);	//Set input speed
  cfsetospeed(&options_port, baud);	//Set output speed
  options_port.c_iflag = 0;		//Clear all Bits
  options_port.c_oflag = 0;		//Clear all Bits
  options_port.c_cflag &= ~CSIZE;	//Clear -> deselected bits for datawidth
  options_port.c_cflag &= ~PARENB;	//Clear -> No use of parity bits
  options_port.c_cflag &= ~CSTOPB;	//Clear -> No use of  second stop bit
  options_port.c_cflag |= CREAD;	//Set -> Enable reciver
  options_port.c_cflag |= CLOCAL;	//Set -> Ignore modem status lines
  options_port.c_cflag |= CS8;		//Set -> Data width to 8 Bit
  options_port.c_lflag &= ~ICANON;	//Clear -> No line based input
  options_port.c_lflag &= ~ECHO;	//Clear -> No echo send
  tcsetattr(fd_rs232, TCSANOW, &options_port); //apply options to port
}
return (fd_rs232);
}

int serial_get(void) {
int n, waitloop;
for (waitloop = 0; waitloop < 500;waitloop++) { //We wait approx 3secs
  usleep(100);	//0.1ms
  n = read(fd_rs232,rs232recbuf,254);
  if (n > 0) {	//We got data
    break;
  }
}
if (n < 0) {
  printf("serial_get: Error while reading serial port\n");
  return -1;
}
if (n == 0) {	//No data seems to cause n= -1 and not 0 at a serial port
  printf("serial_get: No Data recived by serial port\n");
  return -1;
}
if (n > 0) {
  rs232recbuf[n] = 0; //Terminate
  printf("serial_get: Read %i bytes\n",n);
}
return n;
}

void serial_close(void) {
tcflush(fd_rs232, TCIOFLUSH); //Flush all unsend data
close(fd_rs232);
printf("serial_close: %s closed\n",port_to_use);
}
