/* user_in.h
Header file for user_in.c

Copyright (C) 2007 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  US
*/

#ifndef user_in_H
 #define user_in_H


//define the time the user has to hold the key in ms until the 'hold' bit is set
#define KEY_HOLD_DELAY ((u16)500)

//changing KEY_NUMS will require a modification of the source code too
#define KEY_NUMS 4

//define on which pin the keys are connected
#define KEY_DOWN_PIN (1<<2)
#define KEY_UP_PIN (1<<4)
#define KEY_LEFT_PIN (1<<5)
#define KEY_RIGHT_PIN (1<<3)


void keys_thread(void);
void key_flush(void);

void key_wait_until_pressed(void);

u08 key_down_pressed(void);
u08 key_down_hold(void);

u08 key_up_pressed(void);
u08 key_up_hold(void);

u08 key_left_pressed(void);
u08 key_left_hold(void);

u08 key_right_pressed(void);
u08 key_right_hold(void);


#endif
