/* scheduler.h
Header file for scheduler.c.

Copyright (C) 2006-2007 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SCHEDULER_H
 #define SCHEDULER_H

//a value for sched_thread to be read out after reboot
#define WAS_STACK 234
#define WAS_WISHED 235
#define NOT_RUNNING 236

//values below MAX_THREADS are task numbers, numbers above are error codes
//moreover we print the thread number with only two digits
#define MAX_THREADS 100

#define SCHED_THREADS 7

#define SCHED_FIRSTTASK valid_thread

#if (SCHED_THREAD > MAX_THREADS)
  #error "Only MAX_THREADS are allowed"
#endif

struct threadpoint{
void (*execute) (void);
u08 prev_add_stack;
};


extern u08 volatile sched_thread __attribute__ ((section (".noinit")));
extern u16 volatile schedlist_s[SCHED_THREADS];

void sched_init(void);
void sched(void) __attribute__ ((naked));
void sched_init_thread(void) __attribute__ ((noinline));
#endif

