/* rs232_io.h
Header file for rs232_io.h

Copyright (C) 2007-2008 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef interrupt_handling_H
 #define interrupt_handling_H

// 9600 Baud
#define BAUDRATE 9600
#define UARTNUMBER (F_CPU/(BAUDRATE*16l)-1)

void rs232_init(void);
void rs232_put_byte(u08 byte);
u08 rs232_get_nextbyte(void);
void rs232_sendnewline(void);
void rs232_thread(void);
void rs232_println(u08 *text);
void rs232_println_atomic(u08 *text);
void rs232_print_number(u16 val);
void rs232_print_number_u32(u32 val);

#endif

