/* main.h
Header file for main.c.

Copyright (C) 2006-2007 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef MAIN_H
 #define MAIN_H

//Will be needed by avr/delay.h too:
//8MHZ
#define F_CPU 8000000

//External functions
#include <stdlib.h>
#include <avr/io.h>
#include <inttypes.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#include <string.h>
#include <math.h>


//Look into inttypes.h to know what unit8_t means.
typedef uint8_t  u08;
typedef int8_t   s08;
typedef uint16_t u16;
typedef int16_t  s16;
typedef uint32_t u32;
typedef int32_t  s32;

//Some defines
#define led_on() PORTD &= ~(1<<PD2)
#define led_off() PORTD |= (1<<PD2)

//Additional sources
#include "clock.h"
#include "scheduler.h"
#include "rs232_io.h"
#include "ad_converter.h"
#include "lcd.h"
#include "validator.h"
#include "da_output.h"
#include "control.h"
#include "user_in.h"
#include "calibration_config.h"
#include "tools.h"
#include "chargedischarge.h"
#include "charging_delta_detect.h"
#include "battery_settings.h"

//Prototypes of functions

void reset(void);
int main(void);

#endif
