/* da_output.h
Header file for da_output.c

Copyright (C) 2006-2007 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  US
*/

#ifndef da_output_H
 #define da_output_H

//How often the power is corrected according to the measured current (in ms)
#define PWM_POWER_CORRECT_DELAY 500


#define OP_MAIN 0
#define OP_PROBE 1
#define OP_CHARGE 2
#define OP_DISCHARGE 3

extern u08 volatile op_mode;

void da_charge(u16 current);
void da_discharge(u16 current);
void da_main(void);
void da_probe(u16 ch_current, u16 disch_current);
void da_control_thread(void);

#endif
