/* calibration_config.c

Copyright (C) 2007-2008 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  US
*/

#include "main.h"

//Since there were problems with eeprom cell 0 in the past...
u16 eep_placeholder[2] __attribute__ ((section (".eeprom"))) = {0xeeee, 0xaaaa};

//Status if the config is valid loaded
u08 volatile configvalid;


//contains a inverted version of the data in the upper half
u16 eep_config[CALIB_ENTRIES*2] __attribute__ ((section (".eeprom"))) = {
1250, 4092,	//Uppersum
625, 8184,	//Lowersum
1, 1, 		//R2^-1
1,1,		//R3^-1
4950,		//L7805_VOUT
1,		//reserved
~1250, ~4092,	//bit negation of Uppersum
~625, ~8184,	//bit negation of Lowersum
~1, ~1,		//bit negation of R2^-1
~1, ~1,		//bit negation of R3^-1
~4950,		//bit negation of L7805_VOUT
~1		//bit negation of reserved
};

//the same data as fixed default values in the flash
const u16 default_config[CALIB_ENTRIES*2] PROGMEM = {
1250, 4092,	//Uppersum
625, 8184,	//Lowersum
1, 1, 		//R2^-1
1,1,		//R3^-1
4950,		//L7805_VOUT
1,		//reserved
~1250, ~4092,	//bit negation of Uppersum
~625, ~8184,	//bit negation of Lowersum
~1, ~1,		//bit negation of R2^-1
~1, ~1,		//bit negation of R3^-1
~4950,		//bit negation of L7805_VOUT
~1		//bit negation of reserved
};


u16 eep_placeholder2[2] __attribute__ ((section (".eeprom"))) = {0x4242,
                                                                 0x2323};

u16 volatile charger_calib[CALIB_ENTRIES*2];


void eep_loadconf(void) {
//Loads the config, on an error, 1 is returned, otherwise 0
u08 k;
u16 c_a, c_b;
eeprom_read_block(&charger_calib, eep_config, sizeof(charger_calib));
configvalid = 1;
for (k = 0; k < CALIB_ENTRIES; k++) {
  c_a = charger_calib[k];
  c_b = charger_calib[k+CALIB_ENTRIES];
  if ((c_a ^ c_b) != 0xffff) {
    configvalid = 0;
    break;
  }
};
}

//restores default values for the EEPROM, reset for using
void eep_defaulconfig(void) {
u08 k;
u08 a;
u08 * addre = (u08 *)eep_config;
u08 * addrf = (u08 *)default_config;
for (k = 0; k < sizeof(eep_config); k++) {
  a = pgm_read_byte(addrf+k);
  eeprom_write_byte(addre+k, a);
  sched();
}
}

void eep_sendconfig(void) {
u08 k;
u08 temp;
u08 * addr = (u08 *)charger_calib;
for (k = 0; k < sizeof(charger_calib); k++) {
  temp = *(addr+k);
  rs232_put_byte(bintohex(temp >>4));
  rs232_put_byte(bintohex(temp & 0x0f));
}
rs232_sendnewline();
}

void eep_receiveconfig(void) {
u08 k;
u08 a, b;
u08 * addr = (u08 *)eep_config;
for (k = 0; k < sizeof(eep_config); k++) {
  a = hextobin(rs232_get_nextbyte());
  /*Swap the byte (if the received data is right the lower 4 bits will be
    zero afterwards) */
  a = swap(a);
  b = hextobin(rs232_get_nextbyte());
  eeprom_write_byte(addr+k, a | b);
  rs232_put_byte('A');
  sched();
}
rs232_sendnewline();
}

u16 eep_multiplyfactor(u16 value, u08 index) {
return multiplyanddivide(value, charger_calib[index], charger_calib[index+1]);
}
