/*
Header file for battery_settings.c

Copyright (C) 2008 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  US
*/

#ifndef battery_settings_H
  #define battery_settings_H

//This defines the position of the values in the settings array
#define C_IDX_NUM 8

#define C_IDX_CELLS 0
#define C_IDX_MAXVOLTAGE 1
#define C_IDX_CHARGINGCURRENT 2
#define C_IDX_DISCHARGINGCURRENT 3
#define C_IDX_CAPACITY 4
#define C_IDX_CHARGEPERCENT 5
#define C_IDX_CHARGED 6
#define C_IDX_DISCHARGED 7

extern u16 cell_settings[C_IDX_NUM];
extern u08 speedfactor_sel;
extern u08 overchargefactor_sel;
extern u08 deltavuse;

#define SPEEDGRADES 3
#define SPEED_MEDIUMFAST_THRESOLD 50
extern const u08 speedfactor[SPEEDGRADES];
extern const u08 overchargefactor[SPEEDGRADES];

static inline u16 battery_getby_index(u08 idx) {
return cell_settings[idx];
}

static inline void battery_setby_index(u08 idx, u16 value) {
if (idx < C_IDX_NUM) {
  cell_settings[idx] = value;
}
}

static inline u16 battery_get_cells(void) {
return cell_settings[C_IDX_CELLS];
}

static inline void battery_set_cells(u16 cells) {
cell_settings[C_IDX_CELLS] = cells;
}

static inline u16 battery_get_maxv(void) {
return cell_settings[C_IDX_MAXVOLTAGE];
}

static inline void battery_set_maxv(u16 maxv) {
cell_settings[C_IDX_MAXVOLTAGE] = maxv;
}

static inline u16 battery_get_chargingcurrent(void) {
return cell_settings[C_IDX_CHARGINGCURRENT];
}

static inline void battery_set_chargingcurrent(u16 chargingcurrent) {
cell_settings[C_IDX_CHARGINGCURRENT] = chargingcurrent;
}

static inline u16 battery_get_overchargefactor(void) {
return overchargefactor_sel;
}

static inline void battery_set_overchargefactor(u08 overf) {
overchargefactor_sel = overf;
}

static inline u16 battery_get_dischargingcurrent(void) {
return cell_settings[C_IDX_DISCHARGINGCURRENT];
}

static inline void battery_set_dischargingcurrent(u16 dischargingcurrent) {
cell_settings[C_IDX_DISCHARGINGCURRENT] = dischargingcurrent;
}

static inline u16 battery_get_capacity(void) {
return cell_settings[C_IDX_CAPACITY];
}

static inline void battery_set_capacity(u16 capacity) {
cell_settings[C_IDX_CAPACITY] = capacity;
}

static inline u16 battery_get_chargedpercent(void) {
return cell_settings[C_IDX_CHARGEPERCENT];
}

static inline void battery_set_chargedpercent(u16 percent) {
cell_settings[C_IDX_CHARGEPERCENT] = percent;
}

static inline u16 battery_get_charged(void) {
return cell_settings[C_IDX_CHARGED];
}

static inline void battery_set_charged(u16 charged) {
cell_settings[C_IDX_CHARGED] = charged;
}

static inline u16 battery_get_discharged(void) {
return cell_settings[C_IDX_DISCHARGED];
}

static inline void battery_set_discharged(u16 discharged) {
cell_settings[C_IDX_DISCHARGED] = discharged;
}

static inline u16 battery_get_deltavuse(void) {
return deltavuse;
}

static inline void battery_set_deltavuse(u08 use) {
deltavuse = use;
}

static inline u16 battery_get_speedfactor(void) {
return speedfactor_sel;
}

static inline void battery_set_speedfactor(u08 speedf) {
speedfactor_sel = speedf;
}

#endif
