package view;

/* Charge Control Version 1.1 (c) 2008 by Malte Marwedel

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

import java.awt.Dimension;
import java.awt.FlowLayout;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;


/**
 * Provides a window with a progressbar, which is redrawn after every 2% of progress 
 * In the end, this class is useless.
 * 
 * @author Malte Marwedel
 *
 */
public class ShowProgressbar {
  
	private JFrame dialog;
	private JProgressBar jprog;
	private JPanel panel;
	private int maximum;
	
	
  public ShowProgressbar(String text, int maxval) {
    dialog = new JFrame();
    dialog.setTitle(text);
    dialog.setAlwaysOnTop(true);
    maximum =  Math.max(maxval,1);
    jprog = new JProgressBar(0, maximum);
    jprog.setValue(0);
    jprog.setPreferredSize(new Dimension(200,20));
    jprog.setDoubleBuffered(true);
    jprog.setIndeterminate(false);
    panel = new JPanel();
    panel.setLayout(new FlowLayout());
    panel.add(jprog);
    dialog.add(panel);
    dialog.setSize(230, 70);
    dialog.setLocation(300, 250);
    //all those lines of code does not bring the components directly on the screen...
    dialog.setResizable(false);
    dialog.setVisible(true);
    //jprog.updateUI();
    //panel.updateUI();
    //dialog.update(dialog.getGraphics());
    jprog.paint(jprog.getGraphics());
  }
  
  public void setProgress(int value) {
  	int oldvalue = jprog.getValue();
  	value = Math.min(value, maximum);
  	double reldiff = Math.abs(oldvalue-value);
  	reldiff /= ((double)maximum);
  	if ((reldiff > 0.02) ||//more than 2% changed
  			((value == maximum) && (oldvalue != maximum))) { // or 100% reached
  		jprog.setValue(value);
  		jprog.updateUI();
      jprog.paint(jprog.getGraphics());
  		//System.out.println("updated");
  	} 
  }
  
  public void setReaming(int value) {
  	setProgress(jprog.getMaximum()-value);
  }
  
  public void close() {
  	dialog.setVisible(false);
  	dialog.removeAll();
  }
  
}

