package view;

/* Charge Control Version 1.1 (c) 2008 by Malte Marwedel

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

import control.Main;

import model.ReceiveMessage;

public class Prime implements ActionListener, WindowListener {
  
  private JFrame frame;           //The main frame
  private JPanel panelmain;       //The main panel with everything
  private JLabel labelstatus;     //The label with the status
  private JLabel labelport;       //Shows "Port:"
  private JButton buttonopenclose;//Button for opening or closing the port
  private JButton buttonopen;     //opens a compressed datafile
  private JButton buttonimport;   //opens an uncompressed datafile
  private JButton buttoncalibrate;//Button for calibrate screen
  private JButton buttoninfo;     //Button for info dialog
  private JComboBox comboboxport; //The user selects the port
  private String[] avPorts;
  
  
  private ReceiveMessage superrm;
  
  public Prime(ReceiveMessage rm) {
    superrm = rm;
  }
  
  public void createAndShowGUI() {
    //Set window decorations
    JFrame.setDefaultLookAndFeelDecorated(false);
    String workinglaf = UIManager.getSystemLookAndFeelClassName();
    /*I dislike all three available look and feels, but the gtk one is the least worse in my opinion
    javax.swing.plaf.metal.MetalLookAndFeel: I don't like the buttons
    com.sun.java.swing.plaf.gtk.GTKLookAndFeel: Nice buttons but bad file selection menu
    com.sun.java.swing.plaf.motif.MotifLookAndFeel: I don't like it in any way.
    com.sun.java.swing.plaf.windows.WindowsLookAndFeel: May be nice, but not available under my Linux system.
    
    A look like QT (KDE) or full WTK2 (Gnome) would be nice but seem not to exists.
    
    */
    try {
      //UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
      //UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
    	UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
    } catch (Exception e) { //if selection failed
      System.out.println("Prime.createAndShowGUI: Error: wished LookAndFeel could not be set, using "+workinglaf+" instead");
    }
    //Create and set the window
    frame = new JFrame("Charge Control");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.addWindowListener(this);
    frame.setResizable(false);
    //Generate the Layout
    panelmain = new JPanel();
    panelmain.setLayout(null);
    //Add the visible objects
    labelstatus = new JLabel("Charger status: unknown");
    labelstatus.setBounds(10, 5, 310, 40);
    panelmain.add(labelstatus);
    labelport = new JLabel("Port:");
    labelport.setBounds(10, 50, 40, 30);
    comboboxport = new JComboBox();
    comboboxport.setToolTipText("Examples: Linux: /dev/ttyUSB0 Windows: COM1");
    comboboxport.setBounds(60, 50, 150, 30);
    buttonopenclose = new JButton("Open");
    buttonopenclose.setBounds(220, 50, 90, 30);
    panelmain.add(labelport);
    panelmain.add(comboboxport);
    panelmain.add(buttonopenclose);
    buttonopen = new JButton("Open Record");
    buttonopen.setBounds(10, 90, 145, 30);
    buttonimport = new JButton("Import Record");
    buttonimport.setBounds(165, 90, 145, 30);
    panelmain.add(buttonopen);
    panelmain.add(buttonimport);
    buttoncalibrate = new JButton("Calibrate");
    buttoncalibrate.setBounds(10, 130, 145, 30);
    buttoninfo = new JButton("Info");
    buttoninfo.setBounds(165, 130, 145, 30);
    panelmain.add(buttoncalibrate);
    panelmain.add(buttoninfo);
    //Add listeners
    buttonopenclose.setActionCommand("portopenclose");
    buttonopenclose.addActionListener(this);
    buttonopen.setActionCommand("recordopen");
    buttonopen.addActionListener(this);
    buttonimport.setActionCommand("recordimport");
    buttonimport.addActionListener(this);
    buttoncalibrate.setActionCommand("calibrate");
    buttoncalibrate.addActionListener(this);
    buttoninfo.setActionCommand("info");
    buttoninfo.addActionListener(this);
    //Display the window
    frame.add(panelmain);
    frame.pack();
    frame.setLocation(50, 0);
    frame.setSize(330, 195);
    frame.setVisible(true); 
  }
  
  public void actionPerformed(ActionEvent e) {
     if (e.getActionCommand().equals("info")) {
      new ShowMessage(Main.info);
    } else
    superrm.messageTell(e.getActionCommand());
  }
  
  public void disablePortButtons() {
    buttonopenclose.setEnabled(false);
    comboboxport.setEnabled(false);
  }
  
  public void setAvariablePorts(String[] ports) {
  	avPorts = ports;
    for (int i = 0; i < ports.length; i++) {
      comboboxport.addItem(ports[i]);
    }
  }

	public void portClosed() {
		buttonopenclose.setText("Open"); 
  }

	public void portOpened() {
		buttonopenclose.setText("Close");
  }
	
	/**
	 * What is selected, returns an empty string if selection is invalid
	 * @return
	 */
	public String getSelectedPort() {
		if (comboboxport.getSelectedIndex() >= 0) {
			return avPorts[comboboxport.getSelectedIndex()];
		}
		return new String("");
	}

	public void updateChargerState(String chargerstateDescription) {
		labelstatus.setText("Charger status: "+chargerstateDescription);
	}

	public void windowActivated(WindowEvent e) {
		//ignore
	}

	public void windowClosed(WindowEvent e) {
		//ignore
	}

	public void windowClosing(WindowEvent e) {
		superrm.messageTell("appexit");
	}

	public void windowDeactivated(WindowEvent e) {
		//ignore
	}

	public void windowDeiconified(WindowEvent e) {
		//ignore
	}

	public void windowIconified(WindowEvent e) {
		//ignore
	}

	public void windowOpened(WindowEvent e) {
		//ignore
	}

}
