package view;

/* Charge Control Version 1.1 (c) 2008 by Malte Marwedel

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import model.ReceiveMessage;


public class CalibrationWindow implements ActionListener {


	private JFrame frame;
	private JPanel panelmain;	
  private JTextField edval1;
  private JTextField edval2;
  private JTextField edval3;
  private JTextField edval4;
  private JTextField edval5;
  private JLabel lval1;
  private JLabel lval2;
  private JLabel lval3;
  private JLabel lval4;
  private JLabel lval5;
  private JButton bread;
  private JButton bwrite;
  private JButton bsave;
  private JButton bopen;
  private JButton bdefault;
  private JButton breset;
  private JButton bhelp;
  private JButton bclose;
  
  private ReceiveMessage rm;
	
	public CalibrationWindow(ReceiveMessage recm) {
		rm = recm;
		//Create and set the window
    frame = new JFrame("Calibration");
    //Generate the Layout
    panelmain = new JPanel();
    GridLayout gl = new GridLayout(7,4);
    gl.setHgap(10);
    gl.setVgap(10);
    panelmain.setLayout(gl);
    //uppersum
    panelmain.add(new JLabel("Upper Sum factor"));
    edval1 = new JTextField();
    edval1.setActionCommand("labelupdate");
    edval1.addActionListener(this);
    panelmain.add(edval1);
    panelmain.add(new JLabel(""));
    lval1 = new JLabel();
    panelmain.add(lval1);
    //lower
    panelmain.add(new JLabel("Lower Sum factor"));
    edval2 = new JTextField();
    edval2.setActionCommand("labelupdate");
    edval2.addActionListener(this);
    panelmain.add(edval2);
    panelmain.add(new JLabel(""));
    lval2 = new JLabel();
    panelmain.add(lval2);
    //R2
    panelmain.add(new JLabel("R2"));
    edval3 = new JTextField();
    edval3.setActionCommand("labelupdate");
    edval3.addActionListener(this);
    panelmain.add(edval3);
    panelmain.add(new JLabel("Ohm"));
    lval3 = new JLabel();
    panelmain.add(lval3);
    //R3
    panelmain.add(new JLabel("R3"));
    edval4 = new JTextField();
    edval4.setActionCommand("labelupdate");
    edval4.addActionListener(this);
    panelmain.add(edval4);
    panelmain.add(new JLabel("Ohm"));
    lval4 = new JLabel();
    panelmain.add(lval4);
    //Vcc
    panelmain.add(new JLabel("5Vcc"));
    edval5 = new JTextField();
    edval5.setActionCommand("labelupdate");
    edval5.addActionListener(this);
    panelmain.add(edval5);
    panelmain.add(new JLabel("V"));
    lval5 = new JLabel();
    panelmain.add(lval5);
    //add buttons
    bread = new JButton("Read in");
    bread.setActionCommand("read");
    bread.addActionListener(this);
    panelmain.add(bread);
    bwrite = new JButton("Write to");
    bwrite.setActionCommand("write");
    bwrite.addActionListener(this);
    panelmain.add(bwrite);
    bopen = new JButton("Open");
    bopen.setActionCommand("open");
    bopen.addActionListener(this);
    panelmain.add(bopen);
    bsave = new JButton("Save");
    bsave.setActionCommand("save");
    bsave.addActionListener(this);
    panelmain.add(bsave);
    bdefault = new JButton("Reset to default");
    bdefault.setToolTipText("Place the default values into the fields");
    bdefault.setActionCommand("default");
    bdefault.addActionListener(this);
    panelmain.add(bdefault);
    breset = new JButton("Send Reset");
    breset.setToolTipText("Send a reset to the Charger");
    breset.setActionCommand("reset");
    breset.addActionListener(this);
    panelmain.add(breset);    
    bhelp = new JButton("Help");
    bhelp.setActionCommand("help");
    bhelp.addActionListener(this);
    panelmain.add(bhelp);    
    bclose = new JButton("Close");
    bclose.setActionCommand("close");
    bclose.addActionListener(this);
    panelmain.add(bclose);
    //add to frame
    frame.add(panelmain);
    frame.pack();
    frame.setSize(700, 300);
    frame.setLocation(0, 195);
    //disable buttons who are only working if a serial connection is established
    disableSerialComm();
	}

	public void show() {
		frame.setVisible(true);
	}

	public void actionPerformed(ActionEvent e) {
		String cmd = e.getActionCommand();
		if (cmd.equals("close")) {
			frame.setVisible(false);
			return;
		}
		if (cmd.equals("help")) {
			new ShowMessage("The first four values are converted to a rational number a/b where a and b\n\r"+
					            "may have a range of an unsigned 16 bit value. The right field shows the\n\r" +
					            "best fitting value of the entered number.\n\r"+
					            "'Upper Sum factor' is a factor with which the sum of 64 sampled 10Bit A/D value has to be\n\r"+
					            "multiplied to get a value in millivolt. The pin for Upper sum is usually connected\n\r"+
					            "to the positive contact of the battery.\n\r"+
					            "'Lower Sum factor' has a similar meaning, but is connected (more or less) to the negative contact of the battery.\n\r" +
					            "The exact calculation formulas are:\n\r" +
					            "Upper Sum factor = ((1/1023)*Vcc/R7)*(R7+R4)*1000/AMOUNT_OF_SAMPLES, usually the values are: \n\r"+
					            "Upper Sum factor = ((1/1023)*5V/10000Ohm)*(10000Ohm+30000Ohm)*1000/64\n\r"+
					            "Lower Sum factor = (1/1023)*Vcc*1000/AMOUNT_OF_SAMPLES, usually the values are: \n\r"+
					            "Lower Sum factor = (1/1023)*5V*1000/64\n\r");
			return;
		}
		rm.messageTell(cmd);
	}

	public void setEdval1Text(String text) {
		edval1.setText(text);
	}
	
	public void setEdval2Text(String text) {
		edval2.setText(text);
	}
	
	public void setEdval3Text(String text) {
		edval3.setText(text);
	}
	
	public void setEdval4Text(String text) {
		edval4.setText(text);
	}
	
	public void setEdval5Text(String text) {
		edval5.setText(text);
	}
	
	public String getEdval1Text() {
		return edval1.getText();
	}

	public String getEdval2Text() {
		return edval2.getText();
	}
	
	public String getEdval3Text() {
		return edval3.getText();
	}
	
	public String getEdval4Text() {
		return edval4.getText();
	}
	
	public String getEdval5Text() {
		return edval5.getText();
	}

	public void setLval1Text(String text) {
		lval1.setText(text);
	}
	
	public void setLval2Text(String text) {
		lval2.setText(text);
	}
	
	public void setLval3Text(String text) {
		lval3.setText(text);
	}
	
	public void setLval4Text(String text) {
		lval4.setText(text);
	}
	
	public void setLval5Text(String text) {
		lval5.setText(text);
	}
	
	public void enableSerialComm() {
		bread.setEnabled(true);
		bwrite.setEnabled(true);
		breset.setEnabled(true);
	}
	
	public void disableSerialComm() {
		bread.setEnabled(false);
		bwrite.setEnabled(false);
		breset.setEnabled(false);
	}
	
}
