package data;

/* Charge Control Version 1.1 (c) 2008 by Malte Marwedel

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

import java.util.ArrayList;
import java.util.Vector;

import control.Tools;

import model.RecordedData;

public abstract class UsefulData implements RecordedData {
  
  ArrayList<DataEntry> al;
  
  //Information send on the beginning
  int cells = -1;
  int capacity = -1;
  int sPercent = -1;
  
  //Information send on the termination
  char reason = ' ';
  int minutes = -1;
  int hours = -1;
  int tPercent = -1;
  
  public int entries() {
  	return al.size();
  }
    
  public String getDuration() {
    int h = al.size()/(4*60*60);
    int m = al.size()%(4*60*60)/(4*60);
    int s = al.size()%(4*60)/4;
    return new String(h+":"+Tools.intToStr(m,2)+":"+Tools.intToStr(s,2));
  }
  
  /**
   * 
   * @param vde vector where the data should be added to
   * @param averagefactor How many values should merge into one averaged value
   */
  public void addToVector(Vector<DataEntry> vde, int averagefactor) {
    if (averagefactor <= 1) {
      for (int i = 0; i < al.size(); i++) {
        vde.add(al.get(i));
      }
    } else { //paste multiple values to one set
      int powersum = 0; // is not calculated from the other values at the end because of loss of resolution
      int cnt = 0;
      int voltagesum = 0;
      int ampssum = 0;
      for (int i = 0; i < al.size(); i++) {
        voltagesum += al.get(i).getVoltage();
        ampssum += al.get(i).getCurrent();
        powersum += al.get(i).getPower();
        cnt++;
        if (cnt == averagefactor) {
          //Assumes that all DataEntries in one set have the same mode
          DataEntry de = new DataEntry(al.get(i).getMode(), voltagesum/averagefactor, ampssum/averagefactor, powersum/averagefactor);
          vde.add(de);
          cnt = 0;
          voltagesum = 0;
          ampssum = 0;
          powersum = 0;
        }
      }      
      
    }
  }
  
  /**
   * Warning: does alter the recorded values and the data are looking smaller after that
   * Does nothing if 'with' is greater than the number of elements in the UsefulData.
   *
   */
  public void smoothValues(int width) {
  	if (width > al.size())
  		return;
  	
    ArrayList<DataEntry> nal = new ArrayList<DataEntry>();
  	int nv = 0;
  	int na = 0;
  	int np = 0;
  	for (int j = 0; j < width; j++) {
  		nv += al.get(j).getVoltage();
  		na += al.get(j).getCurrent();
  	}
    for (int i = 0; i < al.size()-width; i++) {
  		nv += al.get(i+width).getVoltage();
  		na += al.get(i+width).getCurrent();    	
    	int mode = al.get(0).getMode();
    	np = al.get(i+width).getPower();
    	nal.add(new DataEntry(mode, nv/width,na/width,np));
  		nv -= al.get(i).getVoltage();
  		na -= al.get(i).getCurrent();      	
    }
    al = nal;
  }
  
  public int size() {
    return al.size();
  }
  
  abstract public String getAdvancedDescription();

  public String getReasonName() {
  	switch (reason) {
  		case 'A': return "Abort by user";
  		case 'C': return "Too low charging current"; //charging only
  		case 'P': return "Battery 100% full"; //charing only
  		case 'D': return "-deltaV detected battery full"; //charing only (deprecated)
  		case 'W': return "Weak -deltaV peak"; // (charging only)
  		case 'S': return "Strong -deltaV peak"; // (charging only)
  		case 'R': return "Voltage does not rise"; // (charging only)
  		case 'L': return "Voltage is lower than it was once"; //(charging only)
  		case 'E': return "Empty"; //discharging only
  	}
  	return "Unknown";
  }
  
  public DataEntry getEntry(int i) {
  	return al.get(i);
  }
  
  public int getCellNumbers() {
  	return cells;
  }
  
}
