package data;

import java.util.Vector;

import model.ReceiveMessage;


/**
 * Implements the singleton pattern
 * @author Malte Marwedel
 *
 */
public class SessionNotifier {

	private static SessionNotifier sn;
	
	private Vector<ReceiveMessage> sessions;
	
	private SessionNotifier() {
		sessions = new Vector<ReceiveMessage>();
	}
	
	public static SessionNotifier getInstance() {
		if (sn == null)
			sn = new SessionNotifier();
		return sn;
	}
	
	public void registerListener(ReceiveMessage listener) {
		sessions.add(listener);
	}
	
	public void removeListener(ReceiveMessage listener) {
		sessions.remove(listener);
	}

	public void tellExit() {
		//work with a copy, because the sessions alter the original vector by deregistering
		Vector<ReceiveMessage> sesscopy = new Vector<ReceiveMessage>(sessions);
		for (int i = 0; i < sesscopy.size(); i++) {
			//System.out.println("notify: "+sesscopy.get(i));
			sesscopy.get(i).messageTell("close");
		}
	}
	
}
