package control.detector;


import data.ChargingData;

import model.FullDetect;

/**
 * Tries to do a -DeltaU detection on the given data
 * @author Malte Marwedel
 *
 */
public class NegDeltaUNoNoise implements FullDetect {

	int finsam;
	
	
	public NegDeltaUNoNoise(ChargingData cd) {
		findNegativeDelta(cd);
	}
	
	
	private void findNegativeDelta(ChargingData cd) {
		int perc = 2;
		int datarange = cd.getStoppedPercent()-cd.getBeginningPercent();
		if (cd.getStoppedPercent() == -1 && cd.size() > 1000) //adjust to useful if no valid data are saved
			datarange = 100;
		if (datarange <= 0) { //nothing to detect
			finsam = Integer.MAX_VALUE;			
			return;
		}
		//System.out.println(cd.getStoppedPercent()+ " "+cd.getBeginningPercent());
		int sc = cd.size()/datarange; //how many values are one percent...
		int numavg = perc*sc;
		int i = 0;
		int oldvolts = 0;
		while (i < (cd.size()-numavg)) {
			//average
			int vsum = 0;
			int vmax = 0;
			int vmin = 65000;
			for (int j = 0; j < numavg; j++) {
				int val = cd.getEntry(i+j).getVoltage();
				vsum += val;
				vmax = Math.max(vmax, val);
				vmin = Math.min(vmax, val);				
			}
			int volts = vsum/numavg;
			int noise = vmax-vmin;
			i += numavg;
			if (noise < volts/50) {
				if (oldvolts > volts) { //found
					finsam = i;
					return;
				}
			}
			oldvolts = volts;
		}
		finsam = Integer.MAX_VALUE;
		
	}

/*
	private void printArray(int[] arr) {
		for (int i = 0; i < arr.length; i++) {
			System.out.println("NegDeltaU.printArray: arr["+i+"]"+": "+arr[i]);
		}
	}
	
	*/
	
	public int getStopTime() {
		return finsam;
	}
}
