package control.detector;


import data.ChargingData;

import model.FullDetect;

/**
 * Tries to do a -DeltaU detection on the given data
 * @author Malte Marwedel
 *
 */
public class NegDeltaUFinal implements FullDetect {

	int finsam;
	
	
	public NegDeltaUFinal(ChargingData cd) {
		findNegativeDelta(cd);
	}
	
	
	private void findNegativeDelta(ChargingData cd) {
		int datarange = cd.getStoppedPercent()-cd.getBeginningPercent();
		if (cd.getStoppedPercent() == -1 && cd.size() > 1000) //adjust to useful if no valid data are saved
			datarange = 100;
		System.out.println("NegDeltaUFinal.findNegativeDelta: Datarange:"+datarange);
		if (datarange <= 0) { //nothing to detect
			finsam = Integer.MAX_VALUE;			
			return;
		}
		//System.out.println(cd.getStoppedPercent()+ " "+cd.getBeginningPercent());
		int cells = Math.max(cd.getCellNumbers(),1);
		int sc = cd.size()/datarange; //how many values are one percent...
		voltsumbuff = new int[3];
		System.out.println("voltsummbuff size:"+voltsumbuff.length);
		int i = 0;
		int samples;
		int steep; //as larger, as more sensitive for stopping
		if (cd.size() > 5*60*60*4) {
			steep = 4;
			samples = 180;
		} else {
			steep = 6; //on a fast charge,  the voltage has to rise faster too.
			samples = 120;
		}
		System.out.println("samples: "+samples);
		while (i < (cd.size())) {
			int voltage = cd.getEntry(i).getVoltage();
			int p = i/sc;
			if (checkDeltaU(voltage, p, samples, steep, cells) > 0) {
				finsam = i;
				return;
			}
			i++;
		}
		finsam = Integer.MAX_VALUE;
		
	}
	
	/*
	 * A state machine, realized most the same way as it will be realized in the AVR
	 * call this function every 1/4 second with the current voltage
	 */
	short counter = 0;
	short samevolts;
	int sum = 0;
	int[] voltsumbuff;
	int maxv = 0;
	boolean firstrounddone = false;
	

  private int checkDeltaU(int voltage, int perc, int samples, int steep, int cells) {
  	sum += voltage;
  	counter++;
  	if (counter <= samples) { //just add
  		return 0;
  	}
  	int oldsumvolt = avgBuff();
  	moveBuff(sum);
  	counter = 0;
  	sum = 0;
  	int newsumvolt = avgBuff();
  	maxv = Math.max(maxv, newsumvolt);
  	//System.out.println("Voltage: "+newsumvolt);
  	if (firstrounddone == false) { //do throw the first values away
  		firstrounddone = true;
  		return 0;
  	}
  	int delta = newsumvolt-oldsumvolt;
  	if (delta < samples/steep) {
  		samevolts++;
  		if (delta < 0) {//negative values make detection faster
  			samevolts++;
  		}
  	} else if (delta > samples/2) {
  		samevolts = 0;
  	}
  	if (((newsumvolt+samples*2) < oldsumvolt) && (perc > 70)) {
  		System.out.println("Weak Delta peak detect");
  		return 1;
  	}
  	if ((newsumvolt+samples*5) < oldsumvolt) {
  		System.out.println("Hard Delta peak detect");
  		return 1;
  	}
  	if ((samevolts >= samples/6) && (perc > 60)) {
  		System.out.println("Voltage does not rise");
  		return 1;// yes, now stop
  	}
  	if (((maxv-newsumvolt)/samples) > 8*cells) {
  		System.out.println("Voltage drop detected");
  		return 1;
  	}
  	return 0; //can continue
  }
  
  private void moveBuff(int newval) {
  	for (int i = 1; i < voltsumbuff.length; i++) { //move the buffer
  		voltsumbuff[i] = voltsumbuff[i-1];
  	}
  	voltsumbuff[0] = newval;
  }
  
  private int avgBuff() {
  	int volts = 0;
  	for (int i = 0; i < voltsumbuff.length; i++) { //calculate average value
  		volts += voltsumbuff[i];
  	}
  	volts /= voltsumbuff.length;	
  	return volts;
  }
	
	public int getStopTime() {
		return finsam;
	}
}
