package control.detector;


import data.ChargingData;

import model.FullDetect;

/**
 * Tries to determine if the data are good for a -deltaV or not
 * The used way is:
 * look into every 4minutes data block and count deltaV direction changes if > 10mv
 * 
 * @author Malte Marwedel
 *
 */
public class BadDetect implements FullDetect {

	int finsam;
	
	
	public BadDetect(ChargingData cd) {
		checkBad(cd);
	}
	
	
	private void checkBad(ChargingData cd) {
		boolean dryrun = true;
		int datarange = cd.getStoppedPercent()-cd.getBeginningPercent();
		if (cd.getStoppedPercent() == -1 && cd.size() > 1000) //adjust to useful if no valid data are saved
			datarange = 100;
		if (datarange <= 0) { //nothing to detect
			finsam = Integer.MAX_VALUE;			
			return;
		}
		//System.out.println(cd.getStoppedPercent()+ " "+cd.getBeginningPercent());
		//int numavg = perc*sc;
		int numavg = 240;
		int i = 0;
		int maxnoise= Integer.MIN_VALUE; //for stats only
		int lastvolt = 0;
		int lastdirection = 0;
		while (i < (cd.size()-numavg)) {
			//min, max, avg
			int vdir = 0;
			for (int j = 0; j < numavg; j++) {
				int v = cd.getEntry(i+j).getVoltage();

				int direction;
				if (v-10 >  lastvolt) {
					direction = 1;
				} else if (v+10 < lastvolt) {
					direction = -1;
				} else
					direction = 0;
        if (Math.abs(direction-lastdirection) > 1)
        	vdir += 1;
				
				lastvolt = v;
				lastdirection = direction;
			}
			int noise = vdir;//(numavg/10);
			i += numavg;
			if (!dryrun) { //do not use the first sampled value
				//int relnoise = noise/(Math.max(vmax-vmin, 1));
				if (noise > 10) { //found
					finsam = i;
					System.out.println("BadDetect.checkBad: Info: Looks bad. Noise is: "+noise);
					return;
				}
				maxnoise = Math.max(maxnoise, noise);
			} else
				dryrun = false;
		}
		System.out.println("BadDetect.checkBad: Info: Looks good. Maximum Noise: "+maxnoise);
		finsam = Integer.MAX_VALUE;
		
	}

	
	public int getStopTime() {
		return finsam;
	}
}
