/*Servo Control
  (c) 2005, 2009 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "servo.h"

#define SER1MS F_CPU/1000
#define SERTICK SER1MS/256

uint8_t volatile servo1 = 128; //servo1 = horizontal = x axis
uint8_t volatile servo2 = 128; //servo2 = vertical = y axis

uint8_t volatile cservo = 1;

void servo_init(void) {
	TCCR1A = 0;
	TCCR1B = (1<<CS10); //run on direct clock: 1
	TCNT1 = 0;
	OCR1A = 0; //not important on first run
	TIMSK |= (1<<OCIE1A) | (1<<TOIE1); //enable compare and overflow ints
}

/*
How it works:
Every servo needs a high pulse length between 1 and 2 ms which determins his
position.
The sig_overflow occurs 8M/(2^16) = 122 times per second = every 8ms.
Both servors are pulsed alternating. Meaning every servo gets a pulse
every 16ms.
On the sig_overflow, the proper high pegel is set and the calculated time
for setting it low again is set for the next sig_output_compare.
*/

ISR(SIG_OUTPUT_COMPARE1A) { //switch pins off
	if (cservo == 1) {
		SERVO_PORT &= ~(1<<SERVO_PIN1);
	} else {
		SERVO_PORT &= ~(1<<SERVO_PIN2);
	}
}

ISR(SIG_OVERFLOW1) { //switch pins on
	cservo = 3 - cservo; //toogle betwenn 1 and 2, select next servo
	uint8_t servo;
	TCNT1 = 0;
	if (cservo == 1) {
		SERVO_PORT |= (1<<SERVO_PIN1);
		servo = 255-servo1; //flip the servo direction according to the needs
	} else {
		SERVO_PORT |= (1<<SERVO_PIN2);
		servo = servo2;
	}
	OCR1A = SER1MS + servo*SERTICK;
	if (reading_blocking > 0) //has only indirectly to do with the servos...
		reading_blocking--;
}
