/*
  (c) 2008 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"

u08 volatile press_mode;

void keys_init(void) {
	TCCR2 = (1<<CS22) | (1<<CS21) | (1<<CS20); //prescaler = 1024
	TCNT2 = 0;
	TIMSK |= (1<<TOIE2); //interrupt enabled
}

u08 keys_pressed(void) {
	u08 tmp = press_mode;
	press_mode = 0;
	return tmp;
}

u08 volatile presscount = 0;

ISR(SIG_OVERFLOW2) { //calls every 0,128ms
	if ((PINC & (1<<PC2)) == 0) {
		if (presscount != 0xff) {
			presscount++;
		}
	} else {
		if (presscount > 5) { //short pressed
			press_mode = 1;
		}
		if (presscount > 30) { //1s pressed
			press_mode = 2;
		}
		if (presscount > 90) { //3s pressed
			press_mode = 3;
		}
		presscount = 0;
	}
	TCNT2 = 0;
}
