package view;

/* 3D Scanner Control Version 1.0 (c) 2009 by Malte Marwedel

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;

import control.Main;

public class RootWindow implements WindowListener, ActionListener, AdjustmentListener, MouseListener {

	private Main m;
	
	private JFrame frame;           //The main frame
  private JPanel panelmain;       //The main panel with everything
  private JLabel labelresult;     //The label with the status
  private JLabel labelport;       //Shows "Port:"
  private JButton buttonopenclose;//Button for opening or closing the port
  private JScrollBar scrollx;
  private JScrollBar scrolly;
  private JButton buttonDirect;
  private JButton buttonLinear;
  private JButton buttonVector;
  private JButton buttonLight;
  private JTextField textsx;
  private JTextField textsy;
  private JTextField textex;
  private JTextField textey;
  private JSpinner sresolution;
  private JButton buttonLinearScan;//Button for calibrate screen
  private JButton buttonVectorScan;     //Button for info dialog
  private JComboBox comboboxport; //The user selects the port
  private JLabel jlimage;
  private JButton buttonSaveBin;
  private JButton buttonLoadBin;
  private JButton buttonSavePng;
  private JButton buttonExportPov;
	private JScrollBar scrollcontrast;
	private JRadioButton radioLight;
	private JRadioButton radioDistance;
	

  private String[] avPorts;
  
  
	public RootWindow(Main main) {
		m = main;
		createAndShowGui();
	}
	
	private void createAndShowGui() {
	//Set window decorations
    JFrame.setDefaultLookAndFeelDecorated(false);
    String workinglaf = UIManager.getSystemLookAndFeelClassName();
    /*I dislike all three available look and feels, but the gtk one is the least worse in my opinion
    javax.swing.plaf.metal.MetalLookAndFeel: I don't like the buttons
    com.sun.java.swing.plaf.gtk.GTKLookAndFeel: Nice buttons but bad file selection menu
    com.sun.java.swing.plaf.motif.MotifLookAndFeel: I don't like it in any way.
    com.sun.java.swing.plaf.windows.WindowsLookAndFeel: May be nice, but not available under my Linux system.
    
    A look like QT (KDE) or full WTK2 (Gnome) would be nice but seem not to exists.
    
    */
    try {
      //UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
      //UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
    	UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
    } catch (Exception e) { //if selection failed
      System.out.println("Prime.createAndShowGUI: Error: wished LookAndFeel could not be set, using "+workinglaf+" instead");
    }
    //Create and set the window
    frame = new JFrame("3D Scanner Control 1.0");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.addWindowListener(this);
    frame.setResizable(false);
    //Generate the Layout
    panelmain = new JPanel();
    panelmain.setLayout(null);
    //Add the visible objects
    //everything for the port
    labelport = new JLabel("Port:");
    labelport.setBounds(10, 10, 50, 30);
    comboboxport = new JComboBox();
    comboboxport.setToolTipText("Examples: Linux: /dev/ttyUSB0 Windows: COM1");
    comboboxport.setBounds(70, 10, 210, 30);
    buttonopenclose = new JButton("Open");
    buttonopenclose.setBounds(290, 10, 100, 30);
    panelmain.add(labelport);
    panelmain.add(comboboxport);
    panelmain.add(buttonopenclose);
    //two scrollbars for the position
    scrollx = new JScrollBar();
    scrollx.setValues(127, 1, 0, 256);
    scrollx.setToolTipText("Horizontal position: "+scrollx.getValue());
    scrollx.setBounds(10, 50, 380, 20);
    scrollx.setOrientation(JScrollBar.HORIZONTAL);
    scrolly = new JScrollBar();
    scrolly.setValues(127, 1, 0, 256);
    scrolly.setToolTipText("Vertical position: "+scrolly.getValue());
    scrolly.setBounds(10, 80, 380, 20);
    scrolly.setOrientation(JScrollBar.HORIZONTAL);
    panelmain.add(scrollx);
    panelmain.add(scrolly);
    //everything for the four base functions
    buttonDirect = new JButton("Direct");
    buttonDirect.setBounds(10, 110, 87, 30);
    buttonLinear = new JButton("Linear");
    buttonLinear.setBounds(107, 110, 87, 30);
    buttonVector = new JButton("Vector");
    buttonVector.setBounds(205, 110, 87, 30);
    buttonLight = new JButton("Light");
    buttonLight.setBounds(302, 110, 87, 30);
    panelmain.add(buttonDirect);
    panelmain.add(buttonLinear);
    panelmain.add(buttonVector);
    panelmain.add(buttonLight);
    labelresult = new JLabel("Press a button");
    labelresult.setBounds(10, 150, 380, 30);
    panelmain.add(labelresult);
    //for complete scan range
    JSeparator jsep1 = new JSeparator();
    jsep1.setBounds(10, 185, 380, 1);
    JLabel ldesc = new JLabel("Range P(x,y) to P(x,y) and resolution for scanning");
    ldesc.setBounds(10, 190, 380, 30);
    textsx = new JTextField("0");
    textsx.setBounds(10, 230, 68, 30);
    textsx.setToolTipText("Start position X");
    textsy = new JTextField("0");
    textsy.setBounds(88, 230, 68, 30);
    textsy.setToolTipText("Start position Y");
    textex = new JTextField("255");
    textex.setBounds(166, 230, 68, 30);
    textex.setToolTipText("End position X");
    textey = new JTextField("255");
    textey.setBounds(244, 230, 68, 30);
    textey.setToolTipText("End position Y");
    sresolution = new JSpinner (new SpinnerNumberModel(5,1,32,1));
    sresolution.setBounds(322, 230, 68, 30);
    sresolution.setToolTipText("Resolution of the scan, lower is better, higher is faster");
    buttonLinearScan = new JButton("Scan linear");
    buttonLinearScan.setBounds(10, 270, 185, 30);
    buttonVectorScan = new JButton("Scan vector");
    buttonVectorScan.setBounds(205, 270, 185, 30);
  	buttonSaveBin = new JButton("Save scan");
  	buttonSaveBin.setActionCommand("save");
  	buttonSaveBin.addActionListener(this);
  	buttonSaveBin.setBounds(205, 310, 185, 30);
    buttonLoadBin = new JButton("Load scan");
    buttonLoadBin.setActionCommand("load");
    buttonLoadBin.addActionListener(this);
    buttonLoadBin.setBounds(10, 310, 185, 30);
    panelmain.add(jsep1);
    panelmain.add(ldesc);
    panelmain.add(textsx);
    panelmain.add(textsy);
    panelmain.add(textex);
    panelmain.add(textey);
    panelmain.add(sresolution);
    panelmain.add(buttonLinearScan);
    panelmain.add(buttonVectorScan);
    panelmain.add(buttonSaveBin);
    panelmain.add(buttonLoadBin);
    //for the viewable image
    JSeparator jsep2 = new JSeparator();
    jsep2.setOrientation(JSeparator.VERTICAL);
    jsep2.setBounds(398, 10, 1, 380);
    panelmain.add(jsep2);
  	scrollcontrast = new JScrollBar();
  	scrollcontrast.setOrientation(JScrollBar.VERTICAL);
  	scrollcontrast.setValues(5, 1, 1, 256);
  	scrollcontrast.setToolTipText("Contrast: "+(float)scrollcontrast.getValue()/10);
  	scrollcontrast.setBounds(670, 10, 20, 256);
  	scrollcontrast.addAdjustmentListener(this);
  	radioDistance = new JRadioButton("Draw distance");
  	radioDistance.setSelected(true);
  	radioDistance.setActionCommand("draw");
  	radioDistance.addActionListener(this);
  	radioDistance.setBounds(405, 270, 150, 25);
  	radioLight = new JRadioButton("Draw light");
  	radioLight.setSelected(false);
  	radioLight.setActionCommand("draw");
  	radioLight.addActionListener(this);
  	radioLight.setBounds(555, 270, 150, 25);
  	ButtonGroup bg1 = new ButtonGroup();
  	bg1.add(radioDistance);
  	bg1.add(radioLight);
    buttonExportPov = new JButton("Export PovRay");
    buttonExportPov.setActionCommand("showExport");
    buttonExportPov.addActionListener(this);
  	buttonExportPov.setBounds(405, 310, 137, 30);
    buttonSavePng = new JButton("Save PNG");
    buttonSavePng.setActionCommand("savePNG");
    buttonSavePng.addActionListener(this);
    buttonSavePng.setBounds(552, 310, 137, 30);
  	panelmain.add(scrollcontrast);
  	panelmain.add(radioDistance);
  	panelmain.add(radioLight);
  	panelmain.add(buttonSavePng);
  	panelmain.add(buttonExportPov);
    //Add listeners
    buttonopenclose.setActionCommand("portopenclose");
    buttonopenclose.addActionListener(this);
    buttonDirect.setActionCommand("direct");
    buttonDirect.addActionListener(this);
    buttonLinear.setActionCommand("linear");
    buttonLinear.addActionListener(this);
    buttonVector.setActionCommand("vector");
    buttonVector.addActionListener(this);
    buttonLight.setActionCommand("light");
    buttonLight.addActionListener(this);
    buttonLinearScan.setActionCommand("linearscan");
    buttonLinearScan.addActionListener(this);
    buttonVectorScan.setActionCommand("vectorscan");
    buttonVectorScan.addActionListener(this);
    scrollx.addAdjustmentListener(this);
    scrolly.addAdjustmentListener(this);
    updateImage();
    //Display the window
    frame.add(panelmain);
    frame.pack();
    frame.setLocation(50, 0);
    frame.setSize(700, 390);
    frame.setVisible(true); 
	}
	
	public void changeAreaScan(int asrun) {
		if (asrun != Main.SCAN_MODE_OFF) {
			buttonDirect.setEnabled(false);
			buttonLinear.setEnabled(false);
			buttonVector.setEnabled(false);
			buttonLight.setEnabled(false);
			scrollx.setEnabled(false);
			scrolly.setEnabled(false);
		} else {
			buttonDirect.setEnabled(true);
			buttonLinear.setEnabled(true);
			buttonVector.setEnabled(true);
			buttonLight.setEnabled(true);
			buttonLinearScan.setEnabled(true);
			buttonLinearScan.setActionCommand("linearscan");
			buttonLinearScan.setText("Scan linear");
			buttonVectorScan.setEnabled(true);
			buttonVectorScan.setActionCommand("vectorscan");
			buttonVectorScan.setText("Scan vector");
			scrollx.setEnabled(true);
			scrolly.setEnabled(true);
		}
		if (asrun == Main.SCAN_MODE_LINEAR) { //linear scan
			buttonVectorScan.setEnabled(false);
			buttonLinearScan.setText("Scan linear abort");
			buttonLinearScan.setActionCommand("abortrangescan");
		}
		if (asrun == Main.SCAN_MODE_VECTOR) { //vector scan
			buttonLinearScan.setEnabled(false);
			buttonVectorScan.setText("Scan vector abort");
			buttonVectorScan.setActionCommand("abortrangescan");
		}
	}

	public void updateImage() {
		if (jlimage != null) {
      jlimage.removeAll();
      panelmain.remove(jlimage);
      jlimage = null;
		}
    jlimage = new JLabel(m.getScannerData().getGraphic(radioDistance.isSelected(),
    		(float)scrollcontrast.getValue()/10));
    jlimage.setBounds(405, 10, 256, 256);
    jlimage.addMouseListener(this);
    jlimage.setToolTipText("Middle click sets start point, right click sets final point");
    panelmain.add(jlimage);
	  jlimage.updateUI();
	}
	
  public void setAvariablePorts(String[] ports) {
  	avPorts = ports;
    for (int i = 0; i < ports.length; i++) {
      comboboxport.addItem(ports[i]);
    }
  }

	/**
	 * What is selected, returns an empty string if selection is invalid
	 * @return
	 */
	public String getSelectedPort() {
		if (comboboxport.getSelectedIndex() >= 0) {
			return avPorts[comboboxport.getSelectedIndex()];
		}
		return new String("");
	}

	public void portClosed() {
		buttonopenclose.setText("Open"); 
  }

	public void portOpened() {
		buttonopenclose.setText("Close");
  }
	
	public void actionPerformed(ActionEvent ae) {
		m.messageTell(ae.getActionCommand());
		if (ae.getActionCommand().equals("draw")) {
			updateImage();
		}
	}

	public int getHorizontal() {
		return scrollx.getValue();
	}

	public int getVertical() {
		return scrolly.getValue();
	}

	public void adjustmentValueChanged(AdjustmentEvent arg0) {
		if (arg0.getSource().equals(scrollx)) {
			scrollx.setToolTipText("Horizontal position: "+scrollx.getValue());
			m.messageTell("horizontal");
		}
		if (arg0.getSource().equals(scrolly)) {
			scrolly.setToolTipText("Vertical position: "+scrolly.getValue());
			m.messageTell("vertical");
		}
		if (arg0.getSource().equals(scrollcontrast)) {
			scrollcontrast.setToolTipText("Contrast: "+(float)scrollcontrast.getValue()/10);
			updateImage();
		}
		
	}

	public void setAnswerText(String answer) {
		labelresult.setText("Answer from scanner: "+answer+"");
	}

	public String getSxText() {
		return textsx.getText();
	}

	public String getSyText() {
		return textsy.getText();
	}

	public String getExText() {
		return textex.getText();
	}

	public String getEyText() {
		return textey.getText();
	}

	public int getResolution() {
		//System.out.println(sresolution.getValue());
		return ((Integer)sresolution.getValue()).intValue();
	}

	public void mouseClicked(MouseEvent me) {
		if (me.getButton() == MouseEvent.BUTTON2) {
			textsx.setText(me.getX()+"");
			textsy.setText(255-me.getY()+"");
		}
		if (me.getButton() == MouseEvent.BUTTON3) {
			textex.setText(me.getX()+"");
			textey.setText(255-me.getY()+"");
		}
	}

	public void windowClosing(WindowEvent arg0) {
		m.messageTell("appexit");
	}
	
	public void mouseEntered(MouseEvent arg0) {
		
	}

	public void mouseExited(MouseEvent arg0) {
		
	}

	public void mousePressed(MouseEvent arg0) {
		
	}

	public void mouseReleased(MouseEvent arg0) {
		
	}

	public void windowDeactivated(WindowEvent arg0) {

	}

	public void windowDeiconified(WindowEvent arg0) {

	}

	public void windowIconified(WindowEvent arg0) {

	}

	public void windowOpened(WindowEvent arg0) {

	}
	
	public void windowActivated(WindowEvent arg0) {

	}

	public void windowClosed(WindowEvent arg0) {
	
	}

	
}
