package view;

/* 3D Scanner Control Version 1.0 (c) 2009 by Malte Marwedel

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;

import model.ReceiveMessage;


public class ExportWindow implements ActionListener {


	private ReceiveMessage m;
	
	private JFrame frame;           //The main frame
  private JPanel panelmain;       //The main panel with everything
  private JLabel labelobjects;       //Shows type of objects
  
	private JRadioButton radiocubes;
	private JRadioButton radiospheres;
  
  private JLabel labelcutting;     //The label for the distance
  private JSpinner smindist;    //minimum distance
  private JSpinner smaxdist;    //maximum distance
  
  private JButton buttonPreview;
  private JButton buttonExport;

	private JRadioButton radiotext1;
	private JRadioButton radiotext2;
	private JRadioButton radiotext3;

	public ExportWindow(ReceiveMessage main) {
		m = main;
		createAndShowGui();
	}

	private void createAndShowGui() {
	//Set window decorations
    JFrame.setDefaultLookAndFeelDecorated(false);
    String workinglaf = UIManager.getSystemLookAndFeelClassName();
    /*I dislike all three available look and feels, but the gtk one is the least worse in my opinion
    javax.swing.plaf.metal.MetalLookAndFeel: I don't like the buttons
    com.sun.java.swing.plaf.gtk.GTKLookAndFeel: Nice buttons but bad file selection menu
    com.sun.java.swing.plaf.motif.MotifLookAndFeel: I don't like it in any way.
    com.sun.java.swing.plaf.windows.WindowsLookAndFeel: May be nice, but not available under my Linux system.
    
    A look like QT (KDE) or full WTK2 (Gnome) would be nice but seem not to exists.
    
    */
    try {
      //UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
      //UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
    	UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
    } catch (Exception e) { //if selection failed
      System.out.println("Prime.createAndShowGUI: Error: wished LookAndFeel could not be set, using "+workinglaf+" instead");
    }
    //Create and set the window
    frame = new JFrame("PovRay Export");
    frame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
    frame.setResizable(false);
    //Generate the Layout
    panelmain = new JPanel();
    panelmain.setLayout(null);
    //Add the visible objects
    //which type of objects to use
    labelobjects = new JLabel("Object type:");
    labelobjects.setBounds(10, 10, 100, 30);
    radiospheres = new JRadioButton("Spheres");
  	radiospheres.setSelected(true);
  	radiospheres.setBounds(120, 10, 130, 25);
  	radiocubes = new JRadioButton("Cubes");
  	radiocubes.setSelected(false);
  	radiocubes.setBounds(260, 10, 130, 25);
  	ButtonGroup bg1 = new ButtonGroup();
  	bg1.add(radiospheres);
  	bg1.add(radiocubes);
    panelmain.add(labelobjects);
    panelmain.add(radiospheres);
    panelmain.add(radiocubes);
    //everything for cutting out-of view objects
    labelcutting = new JLabel("Depth limits:");
    labelcutting.setBounds(10, 50, 100, 30);
    smindist = new JSpinner (new SpinnerNumberModel(200,0,3000,10));
    smindist.setBounds(120, 50, 130, 30);
    smindist.setToolTipText("Minimum z distance in mm");
    smaxdist = new JSpinner (new SpinnerNumberModel(1500,0,3000,10));
    smaxdist.setBounds(260, 50, 130, 30);
    smaxdist.setToolTipText("Maximum z distance in mm");
    panelmain.add(labelcutting);
    panelmain.add(smindist);
    panelmain.add(smaxdist);
    //selecting texture
    JLabel labeltexture = new JLabel("Texture:");
    labeltexture.setBounds(10, 90, 60, 30);
    radiotext1 = new JRadioButton("Gray");
  	radiotext1.setSelected(true);
  	radiotext1.setBounds(120, 90, 65, 25);
  	radiotext1.setToolTipText("Simple gray color 0.8");
    radiotext2 = new JRadioButton("Light values");
  	radiotext2.setSelected(false);
  	radiotext2.setBounds(190, 90, 115, 25);
  	radiotext2.setToolTipText("Values from the phototransistor");
    radiotext3 = new JRadioButton("Wood");
  	radiotext3.setSelected(false);
  	radiotext3.setBounds(310, 90, 80, 25);
  	radiotext3.setToolTipText("Wood texture");
  	ButtonGroup bg2 = new ButtonGroup();
  	bg2.add(radiotext1);
  	bg2.add(radiotext2);
  	bg2.add(radiotext3);
  	panelmain.add(labeltexture);
  	panelmain.add(radiotext1);
  	panelmain.add(radiotext2);
  	panelmain.add(radiotext3);
    //buttons
    buttonPreview = new JButton("Preview");
    buttonPreview.setBounds(10, 130, 185, 30);
    buttonPreview.setToolTipText("saves a temporary file 3d-preview.pov in the current directory and tries to call povray");
    buttonExport = new JButton("Export");
    buttonExport.setBounds(205, 130, 185, 30);
    panelmain.add(buttonPreview);
    panelmain.add(buttonExport);
    buttonPreview.setActionCommand("povPreview");
    buttonPreview.addActionListener(this);
    buttonExport.setActionCommand("povExport");
    buttonExport.addActionListener(this);
    //Display the window
    frame.add(panelmain);
    frame.pack();
    frame.setLocation(300, 400);
    frame.setSize(400, 200);
    frame.setVisible(true); 
	}

	public void actionPerformed(ActionEvent e) {
		m.messageTell(e.getActionCommand());
	}

	public void showWindow() {
    frame.setVisible(true); 
	}

	public int getMaxDist() {
		return ((Integer)smaxdist.getValue()).intValue();
	}
	
	public int getMinDist() {
		return ((Integer)smindist.getValue()).intValue();
	}

	public int getObjectType() {
		if (radiospheres.isSelected())
			return 1;
		if (radiocubes.isSelected())
			return 2;
		return 0;
	}

	public int getTextureType() {
		if (radiotext1.isSelected())
			return 0;
		if (radiotext2.isSelected())
			return 1;	
		if (radiotext3.isSelected())
			return 2;		
		return 0;
	}
	
	
}
